/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.authmodule;

import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.security.PrivateKey;
import java.util.Date;
import java.util.UUID;
import net.jami.jams.common.authmodule.AuthTokenResponse;
import net.jami.jams.common.objects.user.AccessLevel;
import net.jami.jams.common.objects.user.User;

public class TokenController {
    private static PrivateKey signingKey;

    public TokenController(PrivateKey signingKey) {
        TokenController.signingKey = signingKey;
    }

    public AuthTokenResponse getToken(User user, String deviceId) {
        AuthTokenResponse authTokenResponse = new AuthTokenResponse();
        JWSHeader jwsHeader = new JWSHeader.Builder(JWSAlgorithm.RS256).type(JOSEObjectType.JWT).build();
        JWTClaimsSet.Builder builder = new JWTClaimsSet.Builder().issuer("JAMS").subject(user.getUsername()).audience("JAMS").claim("oneTimePassword", user.getNeedsPasswordReset()).expirationTime(new Date(System.currentTimeMillis() + 1800000L)).notBeforeTime(new Date(System.currentTimeMillis())).issueTime(new Date(System.currentTimeMillis())).jwtID(UUID.randomUUID().toString());
        if (deviceId != null) {
            builder.claim("scope", (Object)AccessLevel.DEVICE);
            builder.claim("deviceId", deviceId);
            authTokenResponse.setScope(AccessLevel.DEVICE);
        } else {
            builder.claim("scope", (Object)user.getAccessLevel());
            authTokenResponse.setScope(user.getAccessLevel());
        }
        JWTClaimsSet jwtClaims = builder.build();
        SignedJWT signedJWT = new SignedJWT(jwsHeader, jwtClaims);
        try {
            signedJWT.sign(new RSASSASigner(signingKey));
            authTokenResponse.setAccess_token(signedJWT.serialize());
            authTokenResponse.setExpires_in(1800L);
            authTokenResponse.setToken_type("Bearer");
            return authTokenResponse;
        }
        catch (Exception e) {
            return null;
        }
    }
}

