/*
 * Decompiled with CFR 0.152.
 */
package net.jami.datastore.dao;

import java.util.List;
import java.util.Optional;
import net.jami.datastore.dao.AbstractDao;
import net.jami.jams.common.objects.user.Policy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyDao
extends AbstractDao<Policy> {
    private static final Logger log = LoggerFactory.getLogger(PolicyDao.class);

    public PolicyDao() {
        this.setTableName("policies");
        this.setTClass(Policy.class);
    }

    public List<Policy> getAll() {
        return this.getObjectsFromResultSet("SELECT * FROM policies");
    }

    public Optional<Policy> getByName(String name) {
        String q = "SELECT * FROM policies WHERE name = ?";
        return this.getFirstObjectFromResultSet(q, List.of(name));
    }

    public Optional<Policy> getByUsername(String username) {
        String query = "SELECT * FROM usergroupmappings ugm JOIN groups g ON ugm.groupid = g.id JOIN policies p ON g.blueprint = p.name WHERE ugm.username = ?";
        return this.getFirstObjectFromResultSet(query, List.of(username));
    }

    @Override
    public boolean storeObject(Policy object) {
        String query = "INSERT INTO policies (name, policyData) VALUES (?, ?)";
        return this.executeInsert(query, object);
    }

    public boolean updateObject(String name, String policyData) {
        String query = "UPDATE policies SET policyData = ? WHERE name = ?";
        return this.executeUpdate(query, List.of(policyData, name));
    }

    public boolean deleteObject(String name) {
        String query = "DELETE FROM policies WHERE name = ?";
        return this.executeUpdate(query, List.of(name));
    }
}

