/*
 * Decompiled with CFR 0.152.
 */
package net.jami.datastore.dao;

import java.util.List;
import java.util.Optional;
import net.jami.datastore.dao.AbstractDao;
import net.jami.jams.common.objects.devices.Device;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceDao
extends AbstractDao<Device> {
    private static final Logger log = LoggerFactory.getLogger(DeviceDao.class);

    public DeviceDao() {
        this.setTableName("devices");
        this.setTClass(Device.class);
    }

    public List<Device> getByOwner(String owner) {
        return this.getObjectsFromResultSet("SELECT * FROM devices WHERE owner = ?", List.of(owner));
    }

    public Optional<Device> getByDeviceIdAndOwner(String deviceId, String owner) {
        String query = "SELECT * FROM devices WHERE deviceId = ? AND owner = ?";
        Optional<Device> firstObjectFromResultSet = this.getFirstObjectFromResultSet(query, List.of(deviceId, owner));
        return firstObjectFromResultSet;
    }

    @Override
    public boolean storeObject(Device object) {
        String query = "INSERT INTO devices (deviceId, owner, displayName, certificate, privatekey) VALUES (?, ?, ?, ?, ?)";
        return this.executeInsert(query, object);
    }

    public boolean updateObject(String deviceName, String username, String deviceId) {
        String query = "UPDATE devices SET displayName = ? WHERE owner = ? AND deviceId = ?";
        return this.executeUpdate(query, List.of(deviceName, username, deviceId));
    }
}

