/*
 * Decompiled with CFR 0.152.
 */
package net.jami.datastore.dao;

import java.sql.PreparedStatement;
import java.util.List;
import net.jami.datastore.dao.AbstractDao;
import net.jami.datastore.main.DataStore;
import net.jami.jams.common.dao.connectivity.SQLConnection;
import net.jami.jams.common.objects.conversations.Conversation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConversationDao
extends AbstractDao<Conversation> {
    private static final Logger log = LoggerFactory.getLogger(ConversationDao.class);

    public ConversationDao() {
        this.setTableName("conversations");
        this.setTClass(Conversation.class);
    }

    public List<Conversation> getByOwner(String owner) {
        return this.getObjectsFromResultSet("SELECT * FROM conversations WHERE owner = ?", owner);
    }

    @Override
    public boolean storeObject(Conversation object) {
        String query = "INSERT INTO conversations (owner, id, created, removed, erased, members, lastDisplayed) VALUES (?, ?, ?, ?, ?, ?, ?)";
        return this.executeInsert(query, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean storeConversationList(List<Conversation> conversationList) {
        if (conversationList.isEmpty()) {
            log.error("Unable to store empty conversation list.");
            return false;
        }
        SQLConnection connection = DataStore.connectionPool.getConnection();
        if (connection == null) {
            return false;
        }
        try {
            connection.getConnection().setAutoCommit(false);
            String update = "UPDATE conversations SET created = ?, removed = ?, erased = ?, members = ?, lastDisplayed = ?WHERE owner = ? AND id = ?";
            String insert = "INSERT INTO conversations (owner, id, created, removed, erased, members, lastDisplayed) VALUES (?, ?, ?, ?, ?, ?, ?)";
            for (Conversation conversation : conversationList) {
                PreparedStatement updatePs = connection.getConnection().prepareStatement(update);
                try {
                    conversation.getUpdate(updatePs);
                    int rowsUpdated = updatePs.executeUpdate();
                    if (rowsUpdated != 0) continue;
                    PreparedStatement insertPs = connection.getConnection().prepareStatement(insert);
                    try {
                        conversation.getInsert(insertPs);
                        insertPs.executeUpdate();
                    }
                    finally {
                        if (insertPs == null) continue;
                        insertPs.close();
                    }
                }
                finally {
                    if (updatePs == null) continue;
                    updatePs.close();
                }
            }
            connection.getConnection().commit();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.error("An error occurred while attempting to update conversations: {}", (Object)e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            DataStore.connectionPool.returnConnection(connection);
        }
    }
}

