/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.xml;

import ezvcard.VCard;
import ezvcard.VCardDataType;
import ezvcard.io.EmbeddedVCardException;
import ezvcard.io.SkipMeException;
import ezvcard.io.scribe.VCardPropertyScribe;
import ezvcard.io.xml.XCardOutputProperties;
import ezvcard.io.xml.XCardQNames;
import ezvcard.io.xml.XCardWriterBase;
import ezvcard.parameter.VCardParameters;
import ezvcard.property.VCardProperty;
import ezvcard.property.Xml;
import ezvcard.util.ListMultimap;
import ezvcard.util.Utf8Writer;
import ezvcard.util.XmlUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XCardWriter
extends XCardWriterBase {
    private final Document DOC = XmlUtils.createDocument();
    private final Writer writer;
    private final TransformerHandler handler;
    private final boolean vcardsElementExists;
    private boolean started = false;

    public XCardWriter(OutputStream out) {
        this(out, (Integer)null);
    }

    public XCardWriter(OutputStream out, Integer indent) {
        this(out, indent, null);
    }

    public XCardWriter(OutputStream out, Integer indent, String xmlVersion) {
        this(out, (Map<String, String>)new XCardOutputProperties(indent, xmlVersion));
    }

    public XCardWriter(OutputStream out, Map<String, String> outputProperties) {
        this((Writer)new Utf8Writer(out), outputProperties);
    }

    public XCardWriter(File file) throws IOException {
        this(file, (Integer)null);
    }

    public XCardWriter(File file, Integer indent) throws IOException {
        this(file, indent, null);
    }

    public XCardWriter(File file, Integer indent, String xmlVersion) throws IOException {
        this(file, (Map<String, String>)new XCardOutputProperties(indent, xmlVersion));
    }

    public XCardWriter(File file, Map<String, String> outputProperties) throws IOException {
        this((Writer)new Utf8Writer(file), outputProperties);
    }

    public XCardWriter(Writer writer) {
        this(writer, (Integer)null);
    }

    public XCardWriter(Writer writer, Integer indent) {
        this(writer, indent, null);
    }

    public XCardWriter(Writer writer, Integer indent, String xmlVersion) {
        this(writer, (Map<String, String>)new XCardOutputProperties(indent, xmlVersion));
    }

    public XCardWriter(Writer writer, Map<String, String> outputProperties) {
        this(writer, null, outputProperties);
    }

    public XCardWriter(Node parent) {
        this(null, parent, Collections.emptyMap());
    }

    private XCardWriter(Writer writer, Node parent, Map<String, String> outputProperties) {
        Element root;
        this.writer = writer;
        if (parent instanceof Document && (root = ((Document)parent).getDocumentElement()) != null) {
            parent = root;
        }
        this.vcardsElementExists = this.isVCardsElement(parent);
        try {
            SAXTransformerFactory factory = (SAXTransformerFactory)TransformerFactory.newInstance();
            this.handler = factory.newTransformerHandler();
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
        Transformer transformer = this.handler.getTransformer();
        for (Map.Entry<String, String> entry : outputProperties.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            transformer.setOutputProperty(key, value);
        }
        Result result = writer == null ? new DOMResult(parent) : new StreamResult(writer);
        this.handler.setResult(result);
    }

    private boolean isVCardsElement(Node node) {
        if (node == null) {
            return false;
        }
        if (!(node instanceof Element)) {
            return false;
        }
        return XmlUtils.hasQName(node, XCardQNames.VCARDS);
    }

    @Override
    protected void _write(VCard vcard, List<VCardProperty> properties) throws IOException {
        try {
            if (!this.started) {
                this.handler.startDocument();
                if (!this.vcardsElementExists) {
                    this.start(XCardQNames.VCARDS);
                }
                this.started = true;
            }
            ListMultimap<String, VCardProperty> propertiesByGroup = new ListMultimap<String, VCardProperty>();
            for (VCardProperty vCardProperty : properties) {
                propertiesByGroup.put(vCardProperty.getGroup(), vCardProperty);
            }
            this.start(XCardQNames.VCARD);
            for (Map.Entry entry : propertiesByGroup) {
                String groupName = (String)entry.getKey();
                if (groupName != null) {
                    AttributesImpl attr = new AttributesImpl();
                    attr.addAttribute(XCardQNames.NAMESPACE, "", "name", "", groupName);
                    this.start(XCardQNames.GROUP, (Attributes)attr);
                }
                for (VCardProperty property : (List)entry.getValue()) {
                    this.write(property, vcard);
                }
                if (groupName == null) continue;
                this.end(XCardQNames.GROUP);
            }
            this.end(XCardQNames.VCARD);
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            if (!this.started) {
                this.handler.startDocument();
                if (!this.vcardsElementExists) {
                    this.start(XCardQNames.VCARDS);
                }
            }
            if (!this.vcardsElementExists) {
                this.end(XCardQNames.VCARDS);
            }
            this.handler.endDocument();
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
        if (this.writer != null) {
            this.writer.close();
        }
    }

    private void write(VCardProperty property, VCard vcard) throws SAXException {
        Element propertyElement;
        VCardPropertyScribe<? extends VCardProperty> scribe = this.index.getPropertyScribe(property);
        VCardParameters parameters = scribe.prepareParameters(property, this.targetVersion, vcard);
        if (property instanceof Xml) {
            Xml xml = (Xml)property;
            Document value = xml.getValue();
            if (value == null) {
                return;
            }
            propertyElement = value.getDocumentElement();
        } else {
            QName qname = scribe.getQName();
            propertyElement = this.DOC.createElementNS(qname.getNamespaceURI(), qname.getLocalPart());
            try {
                scribe.writeXml(property, propertyElement);
            }
            catch (SkipMeException e) {
                return;
            }
            catch (EmbeddedVCardException e) {
                return;
            }
        }
        this.start(propertyElement);
        this.write(parameters);
        this.write(propertyElement);
        this.end(propertyElement);
    }

    private void write(Element propertyElement) throws SAXException {
        NodeList children = propertyElement.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child instanceof Element) {
                Element element = (Element)child;
                if (element.hasChildNodes()) {
                    this.start(element);
                    this.write(element);
                    this.end(element);
                    continue;
                }
                this.childless(element);
                continue;
            }
            if (!(child instanceof Text)) continue;
            Text text = (Text)child;
            this.text(text.getTextContent());
        }
    }

    private void write(VCardParameters parameters) throws SAXException {
        if (parameters.isEmpty()) {
            return;
        }
        this.start(XCardQNames.PARAMETERS);
        for (Map.Entry parameter : parameters) {
            String parameterName = ((String)parameter.getKey()).toLowerCase();
            this.start(parameterName);
            for (String parameterValue : parameter.getValue()) {
                VCardDataType dataType = (VCardDataType)this.parameterDataTypes.get(parameterName);
                String dataTypeElementName = dataType == null ? "unknown" : dataType.getName().toLowerCase();
                this.start(dataTypeElementName);
                this.text(parameterValue);
                this.end(dataTypeElementName);
            }
            this.end(parameterName);
        }
        this.end(XCardQNames.PARAMETERS);
    }

    private void childless(Element element) throws SAXException {
        Attributes attributes = this.getElementAttributes(element);
        this.handler.startElement(element.getNamespaceURI(), "", element.getLocalName(), attributes);
        this.handler.endElement(element.getNamespaceURI(), "", element.getLocalName());
    }

    private void start(Element element) throws SAXException {
        Attributes attributes = this.getElementAttributes(element);
        this.start(element.getNamespaceURI(), element.getLocalName(), attributes);
    }

    private void start(String element) throws SAXException {
        this.start(element, (Attributes)new AttributesImpl());
    }

    private void start(QName qname) throws SAXException {
        this.start(qname, (Attributes)new AttributesImpl());
    }

    private void start(QName qname, Attributes attributes) throws SAXException {
        this.start(qname.getNamespaceURI(), qname.getLocalPart(), attributes);
    }

    private void start(String element, Attributes attributes) throws SAXException {
        this.start(this.targetVersion.getXmlNamespace(), element, attributes);
    }

    private void start(String namespace, String element, Attributes attributes) throws SAXException {
        this.handler.startElement(namespace, "", element, attributes);
    }

    private void end(Element element) throws SAXException {
        this.end(element.getNamespaceURI(), element.getLocalName());
    }

    private void end(String element) throws SAXException {
        this.end(this.targetVersion.getXmlNamespace(), element);
    }

    private void end(QName qname) throws SAXException {
        this.end(qname.getNamespaceURI(), qname.getLocalPart());
    }

    private void end(String namespace, String element) throws SAXException {
        this.handler.endElement(namespace, "", element);
    }

    private void text(String text) throws SAXException {
        this.handler.characters(text.toCharArray(), 0, text.length());
    }

    private Attributes getElementAttributes(Element element) {
        AttributesImpl attributes = new AttributesImpl();
        NamedNodeMap attributeNodes = element.getAttributes();
        for (int i = 0; i < attributeNodes.getLength(); ++i) {
            Node node = attributeNodes.item(i);
            String localName = node.getLocalName();
            if ("xmlns".equals(localName)) continue;
            attributes.addAttribute(node.getNamespaceURI(), "", localName, "", node.getNodeValue());
        }
        return attributes;
    }
}

