/*
 * Decompiled with CFR 0.152.
 */
package org.zapodot.junit.ldap.internal.unboundid;

import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPInterface;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.Objects;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.FieldAccessor;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.matcher.ElementMatchers;
import org.zapodot.junit.ldap.internal.unboundid.LDAPConnectionProxy;

public class LDAPInterfaceProxyFactory {
    private static final String DELEGATION_FIELD_NAME = "ldapConnection";
    private static final Class<? extends LDAPInterface> proxyType = new ByteBuddy().subclass(LDAPInterface.class).method(ElementMatchers.isDeclaredBy(LDAPInterface.class)).intercept(MethodDelegation.toField("ldapConnection")).defineField("ldapConnection", (Type)((Object)LDAPInterface.class), Visibility.PRIVATE).implement(new Type[]{LDAPConnectionProxy.class}).intercept(FieldAccessor.ofBeanProperty()).make().load(LDAPInterfaceProxyFactory.class.getClassLoader(), ClassLoadingStrategy.Default.WRAPPER).getLoaded();

    private LDAPInterfaceProxyFactory() {
    }

    public static LDAPInterface createProxy(LDAPConnection connection) {
        Objects.requireNonNull(connection, "The \"connection\" argument can not be null");
        return LDAPInterfaceProxyFactory.createConnectionProxy(connection);
    }

    private static LDAPInterface createConnectionProxy(LDAPConnection ldapConnection) {
        LDAPInterface proxy = LDAPInterfaceProxyFactory.createProxyInstance();
        ((LDAPConnectionProxy)((Object)proxy)).setLdapConnection(ldapConnection);
        return proxy;
    }

    private static LDAPInterface createProxyInstance() {
        Constructor<? extends LDAPInterface> constructor = LDAPInterfaceProxyFactory.createConstructorForProxyClass();
        try {
            return constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    private static Constructor<? extends LDAPInterface> createConstructorForProxyClass() {
        try {
            return proxyType.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Found no default constructor for proxy class", e);
        }
    }
}

