/*
 * Decompiled with CFR 0.152.
 */
package org.zapodot.junit.ldap.internal;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import com.unboundid.ldap.listener.InMemoryDirectoryServer;
import com.unboundid.ldap.listener.InMemoryDirectoryServerConfig;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Hashtable;
import java.util.List;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zapodot.junit.ldap.EmbeddedLdapRule;
import org.zapodot.junit.ldap.internal.AuthenticationConfiguration;
import org.zapodot.junit.ldap.internal.jndi.ContextProxyFactory;
import org.zapodot.junit.ldap.internal.unboundid.LDAPInterfaceProxyFactory;

public class EmbeddedLdapRuleImpl
implements EmbeddedLdapRule {
    private static final String JAVA_RT_CONTROL_FACTORY = "com.sun.jndi.ldap.DefaultResponseControlFactory";
    private static final String JAVA_RT_CONTEXT_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";
    private static Logger logger = LoggerFactory.getLogger(EmbeddedLdapRuleImpl.class);
    private final InMemoryDirectoryServer inMemoryDirectoryServer;
    private final AuthenticationConfiguration authenticationConfiguration;
    private LDAPConnection ldapConnection;
    private InitialDirContext initialDirContext;
    private boolean isStarted = false;

    private EmbeddedLdapRuleImpl(InMemoryDirectoryServer inMemoryDirectoryServer, AuthenticationConfiguration authenticationConfiguration1) {
        this.inMemoryDirectoryServer = inMemoryDirectoryServer;
        this.authenticationConfiguration = authenticationConfiguration1;
    }

    public static EmbeddedLdapRule createForConfiguration(InMemoryDirectoryServerConfig inMemoryDirectoryServerConfig, AuthenticationConfiguration authenticationConfiguration, List<String> ldifs) {
        try {
            return new EmbeddedLdapRuleImpl(EmbeddedLdapRuleImpl.createServer(inMemoryDirectoryServerConfig, ldifs), authenticationConfiguration);
        }
        catch (LDAPException e) {
            throw new IllegalStateException("Can not initiate in-memory LDAP server due to an exception", e);
        }
    }

    private static InMemoryDirectoryServer createServer(InMemoryDirectoryServerConfig inMemoryDirectoryServerConfig, List<String> ldifs) throws LDAPException {
        InMemoryDirectoryServer ldapServer = new InMemoryDirectoryServer(inMemoryDirectoryServerConfig);
        if (ldifs != null && !ldifs.isEmpty()) {
            for (String ldif : ldifs) {
                try {
                    ldapServer.importFromLDIF(false, URLDecoder.decode(Resources.getResource(ldif).getPath(), Charsets.UTF_8.name()));
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalStateException("Can not URL decode path:" + Resources.getResource(ldif).getPath(), e);
                }
            }
        }
        return ldapServer;
    }

    @Override
    public LDAPInterface ldapConnection() throws LDAPException {
        return LDAPInterfaceProxyFactory.createProxy(this.createOrGetLdapConnection());
    }

    @Override
    public LDAPConnection unsharedLdapConnection() throws LDAPException {
        return this.createOrGetLdapConnection();
    }

    private LDAPConnection createOrGetLdapConnection() throws LDAPException {
        if (this.isStarted) {
            if (this.ldapConnection == null || !this.ldapConnection.isConnected()) {
                this.ldapConnection = this.inMemoryDirectoryServer.getConnection();
            }
            return this.ldapConnection;
        }
        throw new IllegalStateException("Can not get a LdapConnection before the embedded LDAP server has been started");
    }

    @Override
    public Context context() throws NamingException {
        return ContextProxyFactory.asDelegatingContext(this.createOrGetInitialDirContext());
    }

    @Override
    public DirContext dirContext() throws NamingException {
        return ContextProxyFactory.asDelegatingDirContext(this.createOrGetInitialDirContext());
    }

    @Override
    public int embeddedServerPort() {
        if (this.isStarted) {
            return this.inMemoryDirectoryServer.getListenPort();
        }
        throw new IllegalStateException("The embedded server must be started prior to accessing the listening port");
    }

    private InitialDirContext createOrGetInitialDirContext() throws NamingException {
        if (this.isStarted) {
            if (this.initialDirContext == null) {
                this.initialDirContext = new InitialDirContext(this.createLdapEnvironment());
            }
            return this.initialDirContext;
        }
        throw new IllegalStateException("Can not get an InitialDirContext before the embedded LDAP server has been started");
    }

    private Hashtable<String, String> createLdapEnvironment() {
        Hashtable<String, String> environment = new Hashtable<String, String>();
        environment.put("java.naming.factory.control", JAVA_RT_CONTROL_FACTORY);
        environment.put("java.naming.provider.url", String.format("ldap://%s:%s", this.inMemoryDirectoryServer.getListenAddress().getHostName(), this.embeddedServerPort()));
        environment.put("java.naming.factory.initial", JAVA_RT_CONTEXT_FACTORY);
        if (this.authenticationConfiguration != null) {
            environment.putAll(this.authenticationConfiguration.toAuthenticationEnvironment());
        }
        return environment;
    }

    @Override
    public Statement apply(Statement base, Description description) {
        return this.statement(base);
    }

    private Statement statement(final Statement base) {
        return new Statement(){

            @Override
            public void evaluate() throws Throwable {
                EmbeddedLdapRuleImpl.this.startEmbeddedLdapServer();
                try {
                    base.evaluate();
                }
                finally {
                    EmbeddedLdapRuleImpl.this.takeDownEmbeddedLdapServer();
                }
            }
        };
    }

    private void startEmbeddedLdapServer() throws LDAPException {
        this.inMemoryDirectoryServer.startListening();
        this.isStarted = true;
    }

    private void takeDownEmbeddedLdapServer() {
        try {
            if (this.ldapConnection != null && this.ldapConnection.isConnected()) {
                this.ldapConnection.close();
            }
            if (this.initialDirContext != null) {
                this.initialDirContext.close();
            }
        }
        catch (NamingException e) {
            logger.info("Could not close initial context, forcing server shutdown anyway", e);
        }
        finally {
            this.inMemoryDirectoryServer.shutDown(true);
        }
    }
}

