/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.transport;

import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.ldaptive.BindResponse;
import org.ldaptive.LdapException;
import org.ldaptive.sasl.GssApiBindRequest;
import org.ldaptive.sasl.SaslClient;
import org.ldaptive.transport.TransportConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GssApiSaslClient
implements SaslClient<GssApiBindRequest> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GssApiSaslClient.class);

    @Override
    public BindResponse bind(TransportConnection conn, GssApiBindRequest request) throws LoginException {
        LoginContext context = new LoginContext("ldaptive-gssapi", request);
        context.login();
        BindResponse result = Subject.doAs(context.getSubject(), () -> {
            try {
                return conn.operation(request);
            }
            catch (LdapException e) {
                LOGGER.warn("SASL GSSAPI operation failed for {}", (Object)this, (Object)e);
                return null;
            }
        });
        if (result == null) {
            throw new LoginException("SASL GSSAPI operation failed");
        }
        return result;
    }
}

