/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.schema;

import java.text.ParseException;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ldaptive.LdapUtils;
import org.ldaptive.schema.AbstractNamedSchemaElement;
import org.ldaptive.schema.Extensions;
import org.ldaptive.schema.ObjectClassType;
import org.ldaptive.schema.SchemaUtils;

public class ObjectClass
extends AbstractNamedSchemaElement {
    private static final int HASH_CODE_SEED = 1109;
    private static final Pattern DEFINITION_PATTERN = Pattern.compile("[ ]*\\([ ]*([^ ]+)[ ]*(?:NAME (?:'([^']+)'|\\(([^\\)]+)\\)))?[ ]*(?:DESC '([^']*)')?[ ]*(OBSOLETE)?[ ]*(?:SUP (?:([^ ]+)|\\(([^\\)]+)\\)))?[ ]*(\\p{Alpha}+)?[ ]*(?:MUST (?:([^ ]+)|\\(([^\\)]+)\\)))?[ ]*(?:MAY (?:([^ ]+)|\\(([^\\)]+)\\)))?[ ]*(?:(X-[^ ]+.*))?[ ]*\\)[ ]*");
    private final String oid;
    private String[] superiorClasses;
    private ObjectClassType objectClassType;
    private String[] requiredAttributes;
    private String[] optionalAttributes;

    public ObjectClass(String s2) {
        this.oid = s2;
    }

    public ObjectClass(String oid, String[] names, String description, boolean obsolete, String[] superiorClasses, ObjectClassType objectClassType, String[] requiredAttributes, String[] optionalAttributes, Extensions extensions) {
        this(oid);
        this.setNames(names);
        this.setDescription(description);
        this.setObsolete(obsolete);
        this.setSuperiorClasses(superiorClasses);
        this.setObjectClassType(objectClassType);
        this.setRequiredAttributes(requiredAttributes);
        this.setOptionalAttributes(optionalAttributes);
        this.setExtensions(extensions);
    }

    public String getOID() {
        return this.oid;
    }

    public String[] getSuperiorClasses() {
        return this.superiorClasses;
    }

    public void setSuperiorClasses(String[] s2) {
        this.superiorClasses = s2;
    }

    public ObjectClassType getObjectClassType() {
        return this.objectClassType;
    }

    public void setObjectClassType(ObjectClassType type) {
        this.objectClassType = type;
    }

    public String[] getRequiredAttributes() {
        return this.requiredAttributes;
    }

    public void setRequiredAttributes(String[] s2) {
        this.requiredAttributes = s2;
    }

    public String[] getOptionalAttributes() {
        return this.optionalAttributes;
    }

    public void setOptionalAttributes(String[] s2) {
        this.optionalAttributes = s2;
    }

    public static ObjectClass parse(String definition) throws ParseException {
        Matcher m3 = DEFINITION_PATTERN.matcher(definition);
        if (!m3.matches()) {
            throw new ParseException("Invalid object class definition: " + definition, definition.length());
        }
        ObjectClass ocd = new ObjectClass(m3.group(1).trim());
        if (m3.group(2) != null) {
            ocd.setNames(SchemaUtils.parseDescriptors(m3.group(2).trim()));
        } else if (m3.group(3) != null) {
            ocd.setNames(SchemaUtils.parseDescriptors(m3.group(3).trim()));
        }
        ocd.setDescription(m3.group(4) != null ? m3.group(4).trim() : null);
        ocd.setObsolete(m3.group(5) != null);
        if (m3.group(6) != null) {
            ocd.setSuperiorClasses(SchemaUtils.parseOIDs(m3.group(6).trim()));
        } else if (m3.group(7) != null) {
            ocd.setSuperiorClasses(SchemaUtils.parseOIDs(m3.group(7).trim()));
        }
        if (m3.group(8) != null) {
            ocd.setObjectClassType(ObjectClassType.valueOf(m3.group(8).trim()));
        }
        if (m3.group(9) != null) {
            ocd.setRequiredAttributes(SchemaUtils.parseOIDs(m3.group(9).trim()));
        } else if (m3.group(10) != null) {
            ocd.setRequiredAttributes(SchemaUtils.parseOIDs(m3.group(10).trim()));
        }
        if (m3.group(11) != null) {
            ocd.setOptionalAttributes(SchemaUtils.parseOIDs(m3.group(11).trim()));
        } else if (m3.group(12) != null) {
            ocd.setOptionalAttributes(SchemaUtils.parseOIDs(m3.group(12).trim()));
        }
        if (m3.group(13) != null) {
            ocd.setExtensions(Extensions.parse(m3.group(13).trim()));
        }
        return ocd;
    }

    @Override
    public String format() {
        StringBuilder sb = new StringBuilder("( ");
        sb.append(this.oid).append(" ");
        if (this.getNames() != null && this.getNames().length > 0) {
            sb.append("NAME ");
            sb.append(SchemaUtils.formatDescriptors(this.getNames()));
        }
        if (this.getDescription() != null) {
            sb.append("DESC ");
            sb.append(SchemaUtils.formatDescriptors(this.getDescription()));
        }
        if (this.isObsolete()) {
            sb.append("OBSOLETE ");
        }
        if (this.superiorClasses != null && this.superiorClasses.length > 0) {
            sb.append("SUP ");
            sb.append(SchemaUtils.formatOids(this.superiorClasses));
        }
        if (this.objectClassType != null) {
            sb.append(this.objectClassType.name()).append(" ");
        }
        if (this.requiredAttributes != null && this.requiredAttributes.length > 0) {
            sb.append("MUST ");
            sb.append(SchemaUtils.formatOids(this.requiredAttributes));
        }
        if (this.optionalAttributes != null && this.optionalAttributes.length > 0) {
            sb.append("MAY ");
            sb.append(SchemaUtils.formatOids(this.optionalAttributes));
        }
        if (this.getExtensions() != null) {
            sb.append(this.getExtensions().format());
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ObjectClass) {
            ObjectClass v = (ObjectClass)o;
            return LdapUtils.areEqual(this.oid, v.oid) && LdapUtils.areEqual(this.getNames(), v.getNames()) && LdapUtils.areEqual(this.getDescription(), v.getDescription()) && LdapUtils.areEqual(this.isObsolete(), v.isObsolete()) && LdapUtils.areEqual(this.superiorClasses, v.superiorClasses) && LdapUtils.areEqual((Object)this.objectClassType, (Object)v.objectClassType) && LdapUtils.areEqual(this.requiredAttributes, v.requiredAttributes) && LdapUtils.areEqual(this.optionalAttributes, v.optionalAttributes) && LdapUtils.areEqual(this.getExtensions(), v.getExtensions());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return LdapUtils.computeHashCode(1109, new Object[]{this.oid, this.getNames(), this.getDescription(), this.isObsolete(), this.superiorClasses, this.objectClassType, this.requiredAttributes, this.optionalAttributes, this.getExtensions()});
    }

    public String toString() {
        return "[" + this.getClass().getName() + "@" + this.hashCode() + "::" + "oid=" + this.oid + ", " + "names=" + Arrays.toString(this.getNames()) + ", " + "description=" + this.getDescription() + ", " + "obsolete=" + this.isObsolete() + ", " + "superiorClasses=" + Arrays.toString(this.superiorClasses) + ", " + "objectClassType=" + (Object)((Object)this.objectClassType) + ", " + "requiredAttributes=" + Arrays.toString(this.requiredAttributes) + ", " + "optionalAttributes=" + Arrays.toString(this.optionalAttributes) + ", " + "extensions=" + this.getExtensions() + "]";
    }
}

