/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ldaptive.LdapUtils;
import org.ldaptive.schema.SchemaUtils;

public class Extensions {
    protected static final Pattern DEFINITION_PATTERN = Pattern.compile("(?:(X-[^ ]+)[ ]*(?:'([^']+)'|\\(([^\\)]+)\\))?)+");
    private static final int HASH_CODE_SEED = 1171;
    private final Map<String, List<String>> extensions = new LinkedHashMap<String, List<String>>();

    public Extensions() {
    }

    public Extensions(String name, List<String> values) {
        this.addExtension(name, values);
    }

    public Set<String> getNames() {
        return this.extensions.keySet();
    }

    public List<String> getValues(String name) {
        return this.extensions.get(name);
    }

    public String getValue(String name) {
        List<String> values = this.getValues(name);
        if (values == null || values.isEmpty()) {
            return null;
        }
        return values.iterator().next();
    }

    public Map<String, List<String>> getAllValues() {
        return Collections.unmodifiableMap(this.extensions);
    }

    public void addExtension(String name) {
        this.extensions.put(name, new ArrayList(0));
    }

    public void addExtension(String name, List<String> values) {
        this.extensions.put(name, values);
    }

    public static Extensions parse(String definition) {
        Matcher m3 = DEFINITION_PATTERN.matcher(definition);
        Extensions exts = new Extensions();
        while (m3.find()) {
            String name = m3.group(1).trim();
            ArrayList<String> values = new ArrayList<String>(1);
            if (m3.group(2) != null) {
                values.add(m3.group(2).trim());
            } else if (m3.group(3) != null) {
                values.addAll(Arrays.asList(SchemaUtils.parseDescriptors(m3.group(3).trim())));
            }
            exts.addExtension(name, values);
        }
        return exts;
    }

    public String format() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, List<String>> entry : this.extensions.entrySet()) {
            sb.append(entry.getKey()).append(" ");
            if (entry.getValue() == null || entry.getValue().isEmpty()) continue;
            sb.append(SchemaUtils.formatDescriptors(entry.getValue().toArray(new String[0])));
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Extensions) {
            Extensions v = (Extensions)o;
            return LdapUtils.areEqual(this.extensions, v.extensions);
        }
        return false;
    }

    public int hashCode() {
        return LdapUtils.computeHashCode(1171, this.extensions);
    }

    public String toString() {
        return "[" + this.getClass().getName() + "@" + this.hashCode() + "::" + "extensions=" + this.extensions + "]";
    }
}

