/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.sasl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import org.ldaptive.sasl.DefaultSaslClientRequest;
import org.ldaptive.sasl.Mechanism;
import org.ldaptive.sasl.QualityOfProtection;
import org.ldaptive.sasl.SaslClient;
import org.ldaptive.transport.DefaultSaslClient;
import org.ldaptive.transport.GssApiSaslClient;

public class GssApiBindRequest
extends DefaultSaslClientRequest {
    private static final Mechanism MECHANISM = Mechanism.GSSAPI;
    private final QualityOfProtection[] allowedQoP;
    private final String authenticationID;
    private final String authorizationID;
    private final String realm;
    private final String password;
    private final AtomicBoolean invokeOnce = new AtomicBoolean();

    public GssApiBindRequest(String authID, String authzID, String pass, String r, QualityOfProtection ... qop) {
        QualityOfProtection[] qualityOfProtectionArray;
        if (qop != null) {
            if (qop.length == 0) {
                throw new IllegalArgumentException("QOP cannot be empty");
            }
            Stream.of(qop).forEach(q -> {
                if (q == null) {
                    throw new IllegalArgumentException("QOP cannot be null");
                }
            });
        }
        this.authenticationID = authID;
        this.authorizationID = authzID;
        this.password = pass;
        this.realm = r;
        if (qop != null) {
            qualityOfProtectionArray = qop;
        } else {
            QualityOfProtection[] qualityOfProtectionArray2 = new QualityOfProtection[1];
            qualityOfProtectionArray = qualityOfProtectionArray2;
            qualityOfProtectionArray2[0] = QualityOfProtection.AUTH;
        }
        this.allowedQoP = qualityOfProtectionArray;
    }

    @Override
    public SaslClient getSaslClient() {
        if (this.invokeOnce.compareAndSet(false, true)) {
            return new GssApiSaslClient();
        }
        return new DefaultSaslClient();
    }

    @Override
    public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
        for (Callback callback2 : callbacks) {
            if (callback2 instanceof NameCallback) {
                ((NameCallback)callback2).setName(this.authenticationID);
                continue;
            }
            if (callback2 instanceof PasswordCallback) {
                ((PasswordCallback)callback2).setPassword(this.password.toCharArray());
                continue;
            }
            if (callback2 instanceof RealmCallback) {
                RealmCallback rc = (RealmCallback)callback2;
                if (this.realm == null) {
                    throw new IllegalStateException("Realm required, but none provided");
                }
                rc.setText(this.realm);
                continue;
            }
            throw new UnsupportedCallbackException(callback2);
        }
    }

    @Override
    public Mechanism getMechanism() {
        return MECHANISM;
    }

    @Override
    public String getAuthorizationID() {
        return this.authorizationID;
    }

    @Override
    public Map<String, ?> getSaslProperties() {
        HashMap<String, String> props = new HashMap<String, String>(2);
        props.put("javax.security.sasl.qop", Stream.of(this.allowedQoP).map(QualityOfProtection::string).collect(Collectors.joining(",")));
        props.put("javax.security.sasl.server.authentication", "true");
        return props;
    }

    @Override
    public String toString() {
        return super.toString() + ", " + "allowedQoP=" + Arrays.toString((Object[])this.allowedQoP) + ", " + "authenticationID=" + this.authenticationID + ", " + "authorizationID=" + this.authorizationID + ", " + "realm=" + this.realm;
    }
}

