/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.filter;

import java.lang.reflect.Constructor;
import org.ldaptive.filter.DefaultFilterFunction;
import org.ldaptive.filter.Filter;
import org.ldaptive.filter.FilterFunction;
import org.ldaptive.filter.FilterParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FilterParser {
    private static final String FILTER_FUNCTION_PROPERTY = "org.ldaptive.filter.function";
    private static final Logger LOGGER = LoggerFactory.getLogger(FilterParser.class);
    private static final FilterFunction FILTER_FUNCTION = FilterParser.getFilterFunction();
    private static Constructor<?> filterFunctionConstructor;

    private FilterParser() {
    }

    public static FilterFunction getFilterFunction() {
        if (filterFunctionConstructor != null) {
            try {
                return (FilterFunction)filterFunctionConstructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                LOGGER.error("Error creating new filter function instance with {}", (Object)filterFunctionConstructor, (Object)e);
                throw new IllegalStateException(e);
            }
        }
        return new DefaultFilterFunction();
    }

    public static Filter parse(String filter) throws FilterParseException {
        return FILTER_FUNCTION.parse(filter);
    }

    static {
        String filterFunctionClass = System.getProperty(FILTER_FUNCTION_PROPERTY);
        if (filterFunctionClass != null) {
            try {
                LOGGER.info("Setting ldap filter function to {}", (Object)filterFunctionClass);
                filterFunctionConstructor = Class.forName(filterFunctionClass).getDeclaredConstructor(new Class[0]);
            }
            catch (Exception e) {
                LOGGER.error("Error instantiating {}", (Object)filterFunctionClass, (Object)e);
                throw new IllegalStateException(e);
            }
        }
    }
}

