/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive;

import java.time.Duration;
import org.ldaptive.AbstractConnectionValidator;
import org.ldaptive.Connection;
import org.ldaptive.ReturnAttributes;
import org.ldaptive.SearchOperationHandle;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchConnectionValidator
extends AbstractConnectionValidator {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private SearchRequest searchRequest;

    public SearchConnectionValidator() {
        this(SearchRequest.objectScopeSearchRequest("", ReturnAttributes.NONE.value()));
    }

    public SearchConnectionValidator(SearchRequest sr) {
        this(DEFAULT_VALIDATE_PERIOD, DEFAULT_VALIDATE_TIMEOUT, sr);
    }

    public SearchConnectionValidator(Duration period, Duration timeout, SearchRequest request) {
        this.setValidatePeriod(period);
        this.setValidateTimeout(timeout);
        this.setSearchRequest(request);
    }

    public SearchRequest getSearchRequest() {
        return this.searchRequest;
    }

    public void setSearchRequest(SearchRequest sr) {
        this.searchRequest = sr;
    }

    @Override
    public Boolean apply(Connection conn) {
        if (conn != null) {
            SearchOperationHandle h2 = conn.operation(this.searchRequest);
            try {
                SearchResponse response = h2.execute();
                return response.getResultCode() != null;
            }
            catch (Exception e) {
                this.logger.debug("Connection validator failed for {}", (Object)conn, (Object)e);
            }
        }
        return false;
    }

    public String toString() {
        return "[" + this.getClass().getName() + "@" + this.hashCode() + "::" + "validatePeriod=" + this.getValidatePeriod() + ", " + "validateTimeout=" + this.getValidateTimeout() + ", " + "searchRequest=" + this.searchRequest + "]";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends AbstractConnectionValidator.AbstractBuilder<Builder, SearchConnectionValidator> {
        protected Builder() {
            super(new SearchConnectionValidator());
        }

        @Override
        protected Builder self() {
            return this;
        }

        public Builder request(SearchRequest request) {
            ((SearchConnectionValidator)this.object).setSearchRequest(request);
            return this.self();
        }
    }
}

