/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive;

import java.time.Duration;
import org.ldaptive.AbstractConnectionValidator;
import org.ldaptive.CompareRequest;
import org.ldaptive.CompareResponse;
import org.ldaptive.Connection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompareConnectionValidator
extends AbstractConnectionValidator {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private CompareRequest compareRequest;

    public CompareConnectionValidator() {
        this((CompareRequest)CompareRequest.builder().dn("").name("objectClass").value("top").build());
    }

    public CompareConnectionValidator(CompareRequest cr) {
        this(DEFAULT_VALIDATE_PERIOD, DEFAULT_VALIDATE_TIMEOUT, cr);
    }

    public CompareConnectionValidator(Duration period, Duration timeout, CompareRequest request) {
        this.setValidatePeriod(period);
        this.setValidateTimeout(timeout);
        this.setCompareRequest(request);
    }

    public CompareRequest getCompareRequest() {
        return this.compareRequest;
    }

    public void setCompareRequest(CompareRequest cr) {
        this.compareRequest = cr;
    }

    @Override
    public Boolean apply(Connection conn) {
        if (conn != null) {
            try {
                CompareResponse response = conn.operation(this.compareRequest).execute();
                return response.getResultCode() != null;
            }
            catch (Exception e) {
                this.logger.debug("validation failed for compare request {}", (Object)this.compareRequest, (Object)e);
            }
        }
        return false;
    }

    public String toString() {
        return "[" + this.getClass().getName() + "@" + this.hashCode() + "::" + "validatePeriod=" + this.getValidatePeriod() + ", " + "validateTimeout=" + this.getValidateTimeout() + ", " + "compareRequest=" + this.compareRequest + "]";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends AbstractConnectionValidator.AbstractBuilder<Builder, CompareConnectionValidator> {
        protected Builder() {
            super(new CompareConnectionValidator());
        }

        @Override
        protected Builder self() {
            return this;
        }

        public Builder request(CompareRequest request) {
            ((CompareConnectionValidator)this.object).setCompareRequest(request);
            return this.self();
        }
    }
}

