/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive;

import java.time.Duration;
import org.ldaptive.ConnectionValidator;

public abstract class AbstractConnectionValidator
implements ConnectionValidator {
    public static final Duration DEFAULT_VALIDATE_PERIOD = Duration.ofMinutes(30L);
    public static final Duration DEFAULT_VALIDATE_TIMEOUT = Duration.ofSeconds(5L);
    private Duration validatePeriod;
    private Duration validateTimeout;

    @Override
    public Duration getValidatePeriod() {
        return this.validatePeriod;
    }

    public void setValidatePeriod(Duration period) {
        if (period == null || period.isNegative() || period.isZero()) {
            throw new IllegalArgumentException("Period cannot be null, negative or zero");
        }
        this.validatePeriod = period;
    }

    @Override
    public Duration getValidateTimeout() {
        return this.validateTimeout;
    }

    public void setValidateTimeout(Duration timeout) {
        if (timeout == null || timeout.isNegative()) {
            throw new IllegalArgumentException("Timeout cannot be null or negative");
        }
        this.validateTimeout = timeout;
    }

    protected static abstract class AbstractBuilder<B, T extends AbstractConnectionValidator> {
        protected final T object;

        protected AbstractBuilder(T t) {
            this.object = t;
        }

        protected abstract B self();

        public B period(Duration period) {
            ((AbstractConnectionValidator)this.object).setValidatePeriod(period);
            return this.self();
        }

        public B timeout(Duration timeout) {
            ((AbstractConnectionValidator)this.object).setValidateTimeout(timeout);
            return this.self();
        }

        public T build() {
            return this.object;
        }
    }
}

