/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.api.output;

import java.util.ArrayList;
import java.util.List;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.output.HtmlTableRenderer;
import org.flywaydb.core.api.output.MigrateResult;
import org.flywaydb.core.extensibility.HtmlRenderer;
import org.flywaydb.core.extensibility.HtmlReportSummary;
import org.flywaydb.core.internal.util.FileUtils;
import org.flywaydb.core.internal.util.StringUtils;
import org.flywaydb.core.internal.util.TimeFormat;

public class MigrateHtmlRenderer
implements HtmlRenderer<MigrateResult> {
    @Override
    public String render(MigrateResult result, Configuration config) {
        return this.getBody(result);
    }

    private String getBody(MigrateResult result) {
        StringBuilder html = new StringBuilder("<div>");
        if (result.warnings != null && result.warnings.size() > 0) {
            html.append("  <div><h3>Warnings</h3>\n");
            for (String warning : result.warnings) {
                html.append("    <pre>").append(warning).append("</pre>\n");
            }
            html.append("  </div>\n");
        }
        if (result.migrations != null && result.migrations.size() > 0) {
            HtmlTableRenderer tableRenderer = new HtmlTableRenderer();
            tableRenderer.addHeadings("Version", "Description", "Category", "Type", "Filepath", "ExecutionTime");
            result.migrations.forEach(output -> tableRenderer.addRow(output.version, output.description, output.category, output.type, FileUtils.getFilename(output.filepath), TimeFormat.format(output.executionTime)));
            html.append(tableRenderer.render());
        } else {
            html.append("  <h3>No migrations found</h3>\n");
        }
        html.append("</div>\n");
        return html.toString();
    }

    @Override
    public String tabTitle(MigrateResult result, Configuration config) {
        return config.getDryRunOutput() == null ? "Migration report" : "DryRun report";
    }

    @Override
    public Class<MigrateResult> getType() {
        return MigrateResult.class;
    }

    @Override
    public List<HtmlReportSummary> getHtmlSummary(MigrateResult result) {
        ArrayList<HtmlReportSummary> htmlResult = new ArrayList<HtmlReportSummary>();
        int migratedCount = result.migrationsExecuted;
        String databaseVersion = result.targetSchemaVersion == null ? result.migrations.stream().min((a, b) -> b.version.compareTo(a.version)).map(m3 -> m3.version).orElse("0") : result.targetSchemaVersion;
        htmlResult.add(new HtmlReportSummary(result.targetSchemaVersion != null ? "scGood" : "scError", "infoOutlined", "Database version: " + databaseVersion));
        htmlResult.add(new HtmlReportSummary(migratedCount > 0 ? "scGood" : "scWarn", "checkFilled", migratedCount + " script" + (migratedCount != 1 ? "s" : "") + " migrated"));
        if (StringUtils.hasText(result.schemaName)) {
            htmlResult.add(new HtmlReportSummary("scNote", "database", "Database Schema: " + result.schemaName));
        }
        htmlResult.add(new HtmlReportSummary("scNote", "clockOutlined", "Execution Time: " + TimeFormat.format(result.migrations.stream().mapToInt(i -> i.executionTime).sum())));
        return htmlResult;
    }
}

