/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.runtime;

import jakarta.servlet.jsp.JspWriter;
import jakarta.servlet.jsp.tagext.BodyContent;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.apache.jasper.compiler.Localizer;

public class BodyContentImpl
extends BodyContent {
    private final boolean limitBuffer;
    private final int tagBufferSize;
    private char[] cb;
    private int nextChar;
    private boolean closed;
    private Writer writer;

    public BodyContentImpl(JspWriter enclosingWriter, boolean limitBuffer, int tagBufferSize) {
        super(enclosingWriter);
        this.limitBuffer = limitBuffer;
        this.tagBufferSize = tagBufferSize;
        this.cb = new char[tagBufferSize];
        this.bufferSize = this.cb.length;
        this.nextChar = 0;
        this.closed = false;
    }

    @Override
    public void write(int c) throws IOException {
        if (this.writer != null) {
            this.writer.write(c);
        } else {
            this.ensureOpen();
            if (this.nextChar >= this.bufferSize) {
                this.reAllocBuff(1);
            }
            this.cb[this.nextChar++] = (char)c;
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this.writer != null) {
            this.writer.write(cbuf, off, len);
        } else {
            this.ensureOpen();
            if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return;
            }
            if (len >= this.bufferSize - this.nextChar) {
                this.reAllocBuff(len);
            }
            System.arraycopy(cbuf, off, this.cb, this.nextChar, len);
            this.nextChar += len;
        }
    }

    @Override
    public void write(char[] buf) throws IOException {
        if (this.writer != null) {
            this.writer.write(buf);
        } else {
            this.write(buf, 0, buf.length);
        }
    }

    @Override
    public void write(String s2, int off, int len) throws IOException {
        if (this.writer != null) {
            this.writer.write(s2, off, len);
        } else {
            this.ensureOpen();
            if (len >= this.bufferSize - this.nextChar) {
                this.reAllocBuff(len);
            }
            s2.getChars(off, off + len, this.cb, this.nextChar);
            this.nextChar += len;
        }
    }

    @Override
    public void write(String s2) throws IOException {
        if (this.writer != null) {
            this.writer.write(s2);
        } else {
            this.write(s2, 0, s2.length());
        }
    }

    @Override
    public void newLine() throws IOException {
        if (this.writer != null) {
            this.writer.write(System.lineSeparator());
        } else {
            this.write(System.lineSeparator());
        }
    }

    @Override
    public void print(boolean b) throws IOException {
        if (this.writer != null) {
            this.writer.write(b ? "true" : "false");
        } else {
            this.write(b ? "true" : "false");
        }
    }

    @Override
    public void print(char c) throws IOException {
        if (this.writer != null) {
            this.writer.write(String.valueOf(c));
        } else {
            this.write(String.valueOf(c));
        }
    }

    @Override
    public void print(int i) throws IOException {
        if (this.writer != null) {
            this.writer.write(String.valueOf(i));
        } else {
            this.write(String.valueOf(i));
        }
    }

    @Override
    public void print(long l) throws IOException {
        if (this.writer != null) {
            this.writer.write(String.valueOf(l));
        } else {
            this.write(String.valueOf(l));
        }
    }

    @Override
    public void print(float f) throws IOException {
        if (this.writer != null) {
            this.writer.write(String.valueOf(f));
        } else {
            this.write(String.valueOf(f));
        }
    }

    @Override
    public void print(double d) throws IOException {
        if (this.writer != null) {
            this.writer.write(String.valueOf(d));
        } else {
            this.write(String.valueOf(d));
        }
    }

    @Override
    public void print(char[] s2) throws IOException {
        if (this.writer != null) {
            this.writer.write(s2);
        } else {
            this.write(s2);
        }
    }

    @Override
    public void print(String s2) throws IOException {
        if (s2 == null) {
            s2 = "null";
        }
        if (this.writer != null) {
            this.writer.write(s2);
        } else {
            this.write(s2);
        }
    }

    @Override
    public void print(Object obj) throws IOException {
        if (this.writer != null) {
            this.writer.write(String.valueOf(obj));
        } else {
            this.write(String.valueOf(obj));
        }
    }

    @Override
    public void println() throws IOException {
        this.newLine();
    }

    @Override
    public void println(boolean x) throws IOException {
        this.print(x);
        this.println();
    }

    @Override
    public void println(char x) throws IOException {
        this.print(x);
        this.println();
    }

    @Override
    public void println(int x) throws IOException {
        this.print(x);
        this.println();
    }

    @Override
    public void println(long x) throws IOException {
        this.print(x);
        this.println();
    }

    @Override
    public void println(float x) throws IOException {
        this.print(x);
        this.println();
    }

    @Override
    public void println(double x) throws IOException {
        this.print(x);
        this.println();
    }

    @Override
    public void println(char[] x) throws IOException {
        this.print(x);
        this.println();
    }

    @Override
    public void println(String x) throws IOException {
        this.print(x);
        this.println();
    }

    @Override
    public void println(Object x) throws IOException {
        this.print(x);
        this.println();
    }

    @Override
    public void clear() throws IOException {
        if (this.writer != null) {
            throw new IOException();
        }
        this.nextChar = 0;
        if (this.limitBuffer && this.cb.length > this.tagBufferSize) {
            this.cb = new char[this.tagBufferSize];
            this.bufferSize = this.cb.length;
        }
    }

    @Override
    public void clearBuffer() throws IOException {
        if (this.writer == null) {
            this.clear();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
        } else {
            this.closed = true;
        }
    }

    @Override
    public int getBufferSize() {
        return this.writer == null ? this.bufferSize : 0;
    }

    @Override
    public int getRemaining() {
        return this.writer == null ? this.bufferSize - this.nextChar : 0;
    }

    @Override
    public Reader getReader() {
        return this.writer == null ? new CharArrayReader(this.cb, 0, this.nextChar) : null;
    }

    @Override
    public String getString() {
        return this.writer == null ? new String(this.cb, 0, this.nextChar) : null;
    }

    @Override
    public void writeOut(Writer out) throws IOException {
        if (this.writer == null) {
            out.write(this.cb, 0, this.nextChar);
        }
    }

    void setWriter(Writer writer) {
        this.writer = writer;
        this.closed = false;
        if (writer == null) {
            this.clearBody();
        }
    }

    protected void recycle() {
        this.writer = null;
        try {
            this.clear();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException(Localizer.getMessage("jsp.error.stream.closed"));
        }
    }

    private void reAllocBuff(int len) {
        if (this.bufferSize + len <= this.cb.length) {
            this.bufferSize = this.cb.length;
            return;
        }
        if (len < this.cb.length) {
            len = this.cb.length;
        }
        char[] tmp = new char[this.cb.length + len];
        System.arraycopy(this.cb, 0, tmp, 0, this.cb.length);
        this.cb = tmp;
        this.bufferSize = this.cb.length;
    }
}

