/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.bytecode;

import org.apache.derby.iapi.services.classfile.ClassHolder;
import org.apache.derby.impl.services.bytecode.BCJava;

final class Type {
    static final Type LONG = new Type("long", "J");
    static final Type INT = new Type("int", "I");
    static final Type SHORT = new Type("short", "S");
    static final Type BYTE = new Type("byte", "B");
    static final Type BOOLEAN = new Type("boolean", "Z");
    static final Type FLOAT = new Type("float", "F");
    static final Type DOUBLE = new Type("double", "D");
    static final Type STRING = new Type("java.lang.String", "Ljava/lang/String;");
    private final String javaName;
    private final short vmType;
    private final String vmName;
    final String vmNameSimple;

    Type(String string, String string2) {
        this.vmName = string2;
        this.javaName = string;
        this.vmType = BCJava.vmTypeId(string2);
        this.vmNameSimple = ClassHolder.convertToInternalClassName(string);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        stringBuilder.append(this.javaName);
        stringBuilder.append(", ");
        stringBuilder.append(this.vmType);
        stringBuilder.append(", ");
        stringBuilder.append(this.vmName);
        stringBuilder.append(", ");
        stringBuilder.append(this.vmNameSimple);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    String javaName() {
        return this.javaName;
    }

    String vmName() {
        return this.vmName;
    }

    short vmType() {
        return this.vmType;
    }

    int width() {
        return Type.width(this.vmType);
    }

    static int width(short s2) {
        switch (s2) {
            case -1: {
                return 0;
            }
            case 3: 
            case 5: {
                return 2;
            }
        }
        return 1;
    }
}

