/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.types.BooleanDataValue;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.SQLBoolean;

public abstract class DataType
implements DataValueDescriptor,
Comparable {
    @Override
    public boolean getBoolean() throws StandardException {
        throw this.dataTypeConversion("boolean");
    }

    @Override
    public byte getByte() throws StandardException {
        throw this.dataTypeConversion("byte");
    }

    @Override
    public short getShort() throws StandardException {
        throw this.dataTypeConversion("short");
    }

    @Override
    public int getInt() throws StandardException {
        throw this.dataTypeConversion("int");
    }

    @Override
    public long getLong() throws StandardException {
        throw this.dataTypeConversion("long");
    }

    @Override
    public float getFloat() throws StandardException {
        throw this.dataTypeConversion("float");
    }

    @Override
    public double getDouble() throws StandardException {
        throw this.dataTypeConversion("double");
    }

    @Override
    public int typeToBigDecimal() throws StandardException {
        throw this.dataTypeConversion("java.math.BigDecimal");
    }

    @Override
    public byte[] getBytes() throws StandardException {
        throw this.dataTypeConversion("byte[]");
    }

    @Override
    public Date getDate(Calendar calendar) throws StandardException {
        throw this.dataTypeConversion("java.sql.Date");
    }

    @Override
    public Time getTime(Calendar calendar) throws StandardException {
        throw this.dataTypeConversion("java.sql.Time");
    }

    @Override
    public Timestamp getTimestamp(Calendar calendar) throws StandardException {
        throw this.dataTypeConversion("java.sql.Timestamp");
    }

    @Override
    public InputStream getStream() throws StandardException {
        throw this.dataTypeConversion("InputStream");
    }

    @Override
    public boolean hasStream() {
        return false;
    }

    @Override
    public String getTraceString() throws StandardException {
        return this.getString();
    }

    @Override
    public DataValueDescriptor recycle() {
        this.restoreToNull();
        return this;
    }

    @Override
    public void readExternalFromArray(ArrayInputStream arrayInputStream) throws IOException, ClassNotFoundException {
        this.readExternal(arrayInputStream);
    }

    @Override
    public final BooleanDataValue isNullOp() {
        return SQLBoolean.truthValue(this.isNull());
    }

    @Override
    public final BooleanDataValue isNotNull() {
        return SQLBoolean.truthValue(!this.isNull());
    }

    @Override
    public void setValue(Time time) throws StandardException {
        this.setValue(time, (Calendar)null);
    }

    @Override
    public void setValue(Time time, Calendar calendar) throws StandardException {
        this.throwLangSetMismatch("java.sql.Time");
    }

    @Override
    public void setValue(Timestamp timestamp) throws StandardException {
        this.setValue(timestamp, (Calendar)null);
    }

    @Override
    public void setValue(Timestamp timestamp, Calendar calendar) throws StandardException {
        this.throwLangSetMismatch("java.sql.Timestamp");
    }

    @Override
    public void setValue(Date date) throws StandardException {
        this.setValue(date, (Calendar)null);
    }

    @Override
    public void setValue(Date date, Calendar calendar) throws StandardException {
        this.throwLangSetMismatch("java.sql.Date");
    }

    @Override
    public void setValue(Object object) throws StandardException {
        this.throwLangSetMismatch("java.lang.Object");
    }

    @Override
    public void setValue(String string) throws StandardException {
        this.throwLangSetMismatch("java.lang.String");
    }

    @Override
    public void setValue(Blob blob) throws StandardException {
        this.throwLangSetMismatch("java.sql.Blob");
    }

    @Override
    public void setValue(Clob clob) throws StandardException {
        this.throwLangSetMismatch("java.sql.Clob");
    }

    @Override
    public void setValue(int n) throws StandardException {
        this.throwLangSetMismatch("int");
    }

    @Override
    public void setValue(double d) throws StandardException {
        this.throwLangSetMismatch("double");
    }

    @Override
    public void setValue(float f) throws StandardException {
        this.throwLangSetMismatch("float");
    }

    @Override
    public void setValue(short s2) throws StandardException {
        this.throwLangSetMismatch("short");
    }

    @Override
    public void setValue(long l) throws StandardException {
        this.throwLangSetMismatch("long");
    }

    @Override
    public void setValue(byte by) throws StandardException {
        this.throwLangSetMismatch("byte");
    }

    @Override
    public void setValue(boolean bl) throws StandardException {
        this.throwLangSetMismatch("boolean");
    }

    @Override
    public void setValue(byte[] byArray) throws StandardException {
        this.throwLangSetMismatch("byte[]");
    }

    @Override
    public void setBigDecimal(BigDecimal bigDecimal) throws StandardException {
        this.throwLangSetMismatch("java.math.BigDecimal");
    }

    @Override
    public final void setValue(DataValueDescriptor dataValueDescriptor) throws StandardException {
        if (dataValueDescriptor.isNull()) {
            this.setToNull();
            return;
        }
        try {
            this.setFrom(dataValueDescriptor);
        }
        catch (StandardException standardException) {
            String string = standardException.getMessageId();
            if ("22003".equals(string)) {
                throw this.outOfRange();
            }
            if ("22018".equals(string)) {
                throw this.invalidFormat();
            }
            throw standardException;
        }
    }

    protected void setFrom(DataValueDescriptor dataValueDescriptor) throws StandardException {
        throw StandardException.newException("0A000.S", new Object[0]);
    }

    @Override
    public void setToNull() {
        this.restoreToNull();
    }

    @Override
    public void setObjectForCast(Object object, boolean bl, String string) throws StandardException {
        if (object == null) {
            this.setToNull();
            return;
        }
        if (!bl) {
            throw StandardException.newException("XCL12.S", object.getClass().getName(), this.getTypeName(string));
        }
        this.setObject(object);
    }

    void setObject(Object object) throws StandardException {
        this.genericSetObject(object);
    }

    String getTypeName(String string) {
        return this.getTypeName();
    }

    @Override
    public Object getObject() throws StandardException {
        throw this.dataTypeConversion("java.lang.Object");
    }

    void genericSetObject(Object object) throws StandardException {
        this.throwLangSetMismatch(object);
    }

    @Override
    public DataValueDescriptor cloneHolder() {
        return this.cloneValue(false);
    }

    public void throwLangSetMismatch(Object object) throws StandardException {
        this.throwLangSetMismatch(object.getClass().getName());
    }

    void throwLangSetMismatch(String string) throws StandardException {
        throw StandardException.newException("XCL12.S", string, this.getTypeName());
    }

    @Override
    public void setInto(PreparedStatement preparedStatement, int n) throws SQLException, StandardException {
        preparedStatement.setObject(n, this.getObject());
    }

    @Override
    public void setInto(ResultSet resultSet, int n) throws SQLException, StandardException {
        resultSet.updateObject(n, this.getObject());
    }

    @Override
    public void normalize(DataTypeDescriptor dataTypeDescriptor, DataValueDescriptor dataValueDescriptor) throws StandardException {
        this.setValue(dataValueDescriptor);
    }

    @Override
    public int typePrecedence() {
        return -1;
    }

    @Override
    public BooleanDataValue equals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.compare(dataValueDescriptor2) == 0);
    }

    @Override
    public BooleanDataValue notEquals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.compare(dataValueDescriptor2) != 0);
    }

    @Override
    public BooleanDataValue lessThan(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.compare(dataValueDescriptor2) < 0);
    }

    @Override
    public BooleanDataValue greaterThan(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.compare(dataValueDescriptor2) > 0);
    }

    @Override
    public BooleanDataValue lessOrEquals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.compare(dataValueDescriptor2) <= 0);
    }

    @Override
    public BooleanDataValue greaterOrEquals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.compare(dataValueDescriptor2) >= 0);
    }

    @Override
    public boolean compare(int n, DataValueDescriptor dataValueDescriptor, boolean bl, boolean bl2) throws StandardException {
        if (this.typePrecedence() < dataValueDescriptor.typePrecedence()) {
            return dataValueDescriptor.compare(DataType.flip(n), this, bl, bl2);
        }
        int n2 = this.compare(dataValueDescriptor);
        switch (n) {
            case 1: {
                return n2 < 0;
            }
            case 2: {
                return n2 == 0;
            }
            case 3: {
                return n2 <= 0;
            }
            case 4: {
                return n2 > 0;
            }
            case 5: {
                return n2 >= 0;
            }
        }
        return false;
    }

    @Override
    public boolean compare(int n, DataValueDescriptor dataValueDescriptor, boolean bl, boolean bl2, boolean bl3) throws StandardException {
        if (this.typePrecedence() < dataValueDescriptor.typePrecedence()) {
            return dataValueDescriptor.compare(DataType.flip(n), this, bl, bl2, bl3);
        }
        int n2 = this.compare(dataValueDescriptor, bl2);
        switch (n) {
            case 1: {
                return n2 < 0;
            }
            case 2: {
                return n2 == 0;
            }
            case 3: {
                return n2 <= 0;
            }
            case 4: {
                return n2 > 0;
            }
            case 5: {
                return n2 >= 0;
            }
        }
        return false;
    }

    @Override
    public int compare(DataValueDescriptor dataValueDescriptor, boolean bl) throws StandardException {
        if (this.isNull() || dataValueDescriptor.isNull()) {
            if (!this.isNull()) {
                return bl ? 1 : -1;
            }
            if (!dataValueDescriptor.isNull()) {
                return bl ? -1 : 1;
            }
            return 0;
        }
        return this.compare(dataValueDescriptor);
    }

    public int compareTo(Object object) {
        DataValueDescriptor dataValueDescriptor = (DataValueDescriptor)object;
        try {
            if (this.typePrecedence() < dataValueDescriptor.typePrecedence()) {
                return -1 * dataValueDescriptor.compare(this);
            }
            return this.compare(dataValueDescriptor);
        }
        catch (StandardException standardException) {
            return 0;
        }
    }

    protected static int flip(int n) {
        switch (n) {
            case 1: {
                return 4;
            }
            case 3: {
                return 5;
            }
            case 2: {
                return 2;
            }
        }
        return n;
    }

    @Override
    public DataValueDescriptor coalesce(DataValueDescriptor[] dataValueDescriptorArray, DataValueDescriptor dataValueDescriptor) throws StandardException {
        for (int i = 0; i < dataValueDescriptorArray.length; ++i) {
            if (dataValueDescriptorArray[i].isNull()) continue;
            dataValueDescriptor.setValue(dataValueDescriptorArray[i]);
            return dataValueDescriptor;
        }
        dataValueDescriptor.setToNull();
        return dataValueDescriptor;
    }

    @Override
    public BooleanDataValue in(DataValueDescriptor dataValueDescriptor, DataValueDescriptor[] dataValueDescriptorArray, boolean bl) throws StandardException {
        BooleanDataValue booleanDataValue;
        int n;
        BooleanDataValue booleanDataValue2 = null;
        if (dataValueDescriptor.isNull()) {
            return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptorArray[0], false);
        }
        int n2 = 0;
        int n3 = dataValueDescriptorArray.length;
        int n4 = dataValueDescriptor.typePrecedence();
        DataValueDescriptor dataValueDescriptor2 = null;
        if (bl) {
            while (n3 - n2 > 2) {
                n = (n3 - n2) / 2 + n2;
                dataValueDescriptor2 = n4 < dataValueDescriptorArray[n].typePrecedence() ? dataValueDescriptorArray[n] : dataValueDescriptor;
                booleanDataValue2 = dataValueDescriptor2.equals(dataValueDescriptor, dataValueDescriptorArray[n]);
                if (booleanDataValue2.equals(true)) {
                    return booleanDataValue2;
                }
                booleanDataValue = dataValueDescriptor2.greaterThan(dataValueDescriptorArray[n], dataValueDescriptor);
                if (booleanDataValue.equals(true)) {
                    n3 = n;
                    continue;
                }
                n2 = n;
            }
        }
        for (n = n2; !(n >= n3 || (booleanDataValue2 = (dataValueDescriptor2 = n4 < dataValueDescriptorArray[n].typePrecedence() ? dataValueDescriptorArray[n] : dataValueDescriptor).equals(dataValueDescriptor, dataValueDescriptorArray[n])).equals(true) || bl && (booleanDataValue = dataValueDescriptor2.greaterThan(dataValueDescriptorArray[n], dataValueDescriptor)).equals(true)); ++n) {
        }
        return booleanDataValue2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DataValueDescriptor)) {
            return false;
        }
        try {
            return this.compare(2, (DataValueDescriptor)object, true, false);
        }
        catch (StandardException standardException) {
            return false;
        }
    }

    @Override
    public void setValue(InputStream inputStream, int n) throws StandardException {
        this.throwLangSetMismatch("java.io.InputStream");
    }

    @Override
    public void checkHostVariable(int n) throws StandardException {
    }

    protected final StandardException dataTypeConversion(String string) {
        return StandardException.newException("22005", string, this.getTypeName());
    }

    protected final StandardException outOfRange() {
        return StandardException.newException("22003", this.getTypeName());
    }

    protected final StandardException invalidFormat() {
        return StandardException.newException("22018", this.getTypeName());
    }
}

