/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.servlets.api.jaminameserver;

import com.google.gson.Gson;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;
import net.jami.jams.common.annotations.JsonContent;
import net.jami.jams.common.serialization.adapters.GsonFactory;
import net.jami.jams.common.serialization.tomcat.TomcatCustomErrorHandler;
import net.jami.jams.server.Server;

@WebServlet(value={"/api/nameserver/addr/*"})
public class AddressServlet
extends HttpServlet {
    @Override
    @JsonContent
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String[] path = req.getPathInfo().split("/");
        String username = Server.nameServer.getNameFromAddress(path[path.length - 1]);
        resp.setContentType("application/json;charset=UTF-8");
        if (username == null) {
            TomcatCustomErrorHandler.sendCustomError((HttpServletResponse)resp, (int)404, (String)"Address not found!");
            return;
        }
        Gson gson = GsonFactory.createGson();
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("name", username);
        resp.getWriter().write(gson.toJson(response));
    }
}

