/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.servlets.api.install;

import com.google.gson.Gson;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Reader;
import net.jami.jams.common.objects.requests.CreateCARequest;
import net.jami.jams.common.objects.user.AccessLevel;
import net.jami.jams.common.serialization.adapters.GsonFactory;
import net.jami.jams.common.serialization.tomcat.TomcatCustomErrorHandler;
import net.jami.jams.common.utils.Validator;
import net.jami.jams.server.servlets.api.install.CachedObjects;

@WebServlet(value={"/api/install/ca"})
public class CreateCAServlet
extends HttpServlet {
    private final Gson gson = GsonFactory.createGson();

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)req.getAttribute("accessLevel");
        if (accessLevel == AccessLevel.valueOf((String)"ADMIN")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError((HttpServletResponse)resp, (int)403, (String)"You do not have sufficient permissions to access this resource!");
            return;
        }
        super.doGet(req, resp);
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)req.getAttribute("accessLevel");
        if (accessLevel == AccessLevel.valueOf((String)"ADMIN")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError((HttpServletResponse)resp, (int)403, (String)"You do not have sufficient permissions to access this resource!");
            return;
        }
        CreateCARequest caRequest = this.gson.fromJson((Reader)req.getReader(), CreateCARequest.class);
        if (!Validator.validateCARequests((CreateCARequest)caRequest)) {
            resp.sendError(500, "Certificate was either not a CA or the private key did not match the certificate");
        } else {
            CachedObjects.createCARequest = caRequest;
            CachedObjects.endpoint = "/api/install/auth";
        }
    }
}

