/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.servlets.api.admin.group;

import com.google.gson.Gson;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import net.jami.jams.common.annotations.JsonContent;
import net.jami.jams.common.objects.user.AccessLevel;
import net.jami.jams.common.objects.user.Policy;
import net.jami.jams.common.serialization.adapters.GsonFactory;
import net.jami.jams.common.serialization.tomcat.TomcatCustomErrorHandler;
import net.jami.jams.server.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(value={"/api/admin/policy/*"})
public class PolicyProfileServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(PolicyProfileServlet.class);
    private static final Gson gson = GsonFactory.createGson();

    @Override
    @JsonContent
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)req.getAttribute("accessLevel");
        if (accessLevel == AccessLevel.valueOf((String)"ADMIN")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError((HttpServletResponse)resp, (int)403, (String)"You do not have sufficient permissions to access this resource!");
            return;
        }
        String name = req.getPathInfo().replace("/", "");
        PolicyProfileServlet.getPolicyAndSendResponse(resp, name);
    }

    public static void getPolicyAndSendResponse(HttpServletResponse resp, String name) throws IOException {
        if (name.equals("*")) {
            List<Policy> policies = Server.dataStore.getPolicyDao().getAll();
            resp.getOutputStream().write(gson.toJson(policies).getBytes());
            resp.flushBuffer();
            resp.setStatus(200);
            return;
        }
        Optional<Policy> policy = Server.dataStore.getPolicyDao().getByName(name);
        if (policy.isPresent()) {
            byte[] bytes = gson.toJson(policy.orElseThrow()).getBytes();
            resp.getOutputStream().write(bytes);
            resp.flushBuffer();
            resp.setStatus(200);
        } else {
            resp.sendError(404, "{\"message\": \"No policy found.\"}");
        }
    }
}

