/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.servlets.api.admin.devices;

import com.google.gson.Gson;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import net.jami.jams.common.objects.devices.Device;
import net.jami.jams.common.objects.responses.DeviceRevocationResponse;
import net.jami.jams.common.objects.user.AccessLevel;
import net.jami.jams.common.serialization.adapters.GsonFactory;
import net.jami.jams.common.serialization.tomcat.TomcatCustomErrorHandler;
import net.jami.jams.server.Server;
import net.jami.jams.server.core.workflows.RevokeDeviceFlow;

@WebServlet(value={"/api/admin/device"})
public class DeviceServlet
extends HttpServlet {
    private final Gson gson = GsonFactory.createGson();

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)req.getAttribute("accessLevel");
        if (accessLevel == AccessLevel.valueOf((String)"ADMIN")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError((HttpServletResponse)resp, (int)403, (String)"You do not have sufficient permissions to access this resource!");
            return;
        }
        String username = req.getParameter("username");
        String deviceId = req.getParameter("deviceId");
        Device device = Server.dataStore.getDeviceDao().getByDeviceIdAndOwner(deviceId, username).orElseThrow();
        resp.getOutputStream().write(this.gson.toJson(device).getBytes());
        resp.flushBuffer();
    }

    @Override
    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)req.getAttribute("accessLevel");
        if (accessLevel == AccessLevel.valueOf((String)"ADMIN")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError((HttpServletResponse)resp, (int)403, (String)"You do not have sufficient permissions to access this resource!");
            return;
        }
        String username = req.getParameter("username");
        String deviceId = req.getParameter("deviceId");
        String deviceName = req.getParameter("deviceName");
        if (Server.dataStore.getDeviceDao().updateObject(deviceName, username, deviceId)) {
            resp.setStatus(200);
        } else {
            resp.sendError(500, "An error occurred while updating device information!");
        }
    }

    @Override
    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String deviceId;
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)req.getAttribute("accessLevel");
        if (accessLevel == AccessLevel.valueOf((String)"ADMIN")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError((HttpServletResponse)resp, (int)403, (String)"You do not have sufficient permissions to access this resource!");
            return;
        }
        String username = req.getParameter("username");
        DeviceRevocationResponse devResponse = RevokeDeviceFlow.revokeDevice(username, deviceId = req.getParameter("deviceId"));
        if (devResponse != null) {
            resp.getOutputStream().write(this.gson.toJson(devResponse).getBytes());
            resp.flushBuffer();
        } else {
            resp.sendError(500, "An error occurred while revoking device!");
        }
    }
}

