/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.ldap.connector.service;

import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.jami.datastore.main.DataStore;
import net.jami.jams.common.objects.user.UserProfile;
import net.jami.jams.ldap.connector.LDAPConnector;
import net.jami.jams.server.core.workflows.RevokeUserFlow;
import org.ldaptive.Connection;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.LdapEntry;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserProfileService {
    private static final Logger log = LoggerFactory.getLogger(UserProfileService.class);
    private static DataStore dataStore;
    private final ConnectionFactory connectionFactory;

    public UserProfileService(DataStore dataStore, ConnectionFactory connectionFactory) {
        UserProfileService.dataStore = dataStore;
        this.connectionFactory = connectionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<UserProfile> getUserProfile(String queryString, String field, boolean exactMatch, Optional<Integer> page) {
        try (Connection connection = null;){
            queryString = new String(queryString.getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1);
            connection = this.connectionFactory.getConnection();
            connection.open();
            SearchOperation search = new SearchOperation(this.connectionFactory);
            SearchResponse res = search.execute(UserProfileService.buildRequest(queryString, field, exactMatch));
            Collection<LdapEntry> entries = this.getEntriesPage(res, page);
            if (entries.isEmpty()) {
                ArrayList<UserProfile> arrayList = new ArrayList<UserProfile>();
                return arrayList;
            }
            List profilesFromResponse = entries.stream().map(UserProfileService::profileFromResponse).collect(Collectors.toList());
            for (UserProfile p : profilesFromResponse) {
                dataStore.getUserProfileDao().insertIfNotExists(p);
            }
            List list = profilesFromResponse;
            return list;
        }
    }

    private Collection<LdapEntry> getEntriesPage(SearchResponse res, Optional<Integer> page) {
        int size = res.getEntries().size();
        DataStore.NUM_PAGES = Integer.valueOf(size) / DataStore.RESULTS_PER_PAGE;
        if (size % DataStore.RESULTS_PER_PAGE != 0) {
            Integer n = DataStore.NUM_PAGES;
            Integer n2 = DataStore.NUM_PAGES = Integer.valueOf(DataStore.NUM_PAGES + 1);
        }
        if (page.isEmpty() || size == 0) {
            return res.getEntries();
        }
        res = size < DataStore.RESULTS_PER_PAGE ? res.subResult(0, size) : (page.get() * DataStore.RESULTS_PER_PAGE > size ? res.subResult((page.get() - 1) * DataStore.RESULTS_PER_PAGE, size) : res.subResult((page.get() - 1) * DataStore.RESULTS_PER_PAGE, page.get() * DataStore.RESULTS_PER_PAGE));
        return res.getEntries();
    }

    public static SearchRequest buildRequest(String queryString, String field, boolean exactMatch) {
        if (!exactMatch) {
            if (!queryString.startsWith("*")) {
                queryString = "*".concat(queryString);
            }
            if (!queryString.endsWith("*")) {
                queryString = queryString.concat("*");
            }
        }
        if (field.equals("LOGON_NAME")) {
            return (SearchRequest)SearchRequest.builder().dn(LDAPConnector.settings.getBaseDN()).filter("(&(uid=" + queryString + "))").build();
        }
        if (field.equals("FULL_TEXT_NAME")) {
            return (SearchRequest)SearchRequest.builder().dn(LDAPConnector.settings.getBaseDN()).filter("(|(givenName=" + queryString + ")(sn=" + queryString + ")").build();
        }
        return null;
    }

    public static UserProfile profileFromResponse(LdapEntry entry) {
        HashMap fieldMap = LDAPConnector.settings.getFieldMappings();
        try {
            UserProfile userProfile = new UserProfile();
            for (String attribute : entry.getAttributeNames()) {
                if (!fieldMap.containsKey(attribute)) continue;
                ((Method)UserProfile.exposedMethods.get("set" + (String)fieldMap.get(attribute))).invoke((Object)userProfile, entry.getAttribute(attribute).getStringValue());
            }
            userProfile.setDefaultValues();
            return userProfile;
        }
        catch (Exception e) {
            log.error("An error occurred while invoking methods: " + e);
            return null;
        }
    }

    public void synchronizeUsersWithLDAP() {
        log.info("Synchronizing LDAP user profiles");
        List<UserProfile> profilesFromLDAP = this.getUserProfile("*", "LOGON_NAME", false, Optional.empty());
        if (profilesFromLDAP != null) {
            List<UserProfile> profilesFromDatabase = dataStore.getUserProfileDao().getAllUserProfile();
            for (UserProfile p : profilesFromDatabase) {
                if (!profilesFromLDAP.stream().noneMatch(r -> r.getUsername().equals(p.getUsername()))) continue;
                log.info("Revoking user " + p.getUsername() + " from the database.");
                RevokeUserFlow.revokeUser(p.getUsername());
                dataStore.getUserProfileDao().deleteUserProfile(p.getUsername());
            }
        }
    }
}

