/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.ldap.connector.service;

import net.jami.jams.ldap.connector.LDAPConnector;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.Credential;
import org.ldaptive.auth.AuthenticationRequest;
import org.ldaptive.auth.AuthenticationResponse;
import org.ldaptive.auth.Authenticator;
import org.ldaptive.auth.FormatDnResolver;
import org.ldaptive.auth.SimpleBindAuthenticationHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationService {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationService.class);
    private final ConnectionFactory connectionFactory;

    public AuthenticationService(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public boolean authenticateUser(String username, String password) {
        try {
            FormatDnResolver dnResolver = new FormatDnResolver();
            dnResolver.setFormat(LDAPConnector.settings.getUsernameField() + "=%s," + LDAPConnector.settings.getBaseDN());
            SimpleBindAuthenticationHandler bindAuthenticationHandler = new SimpleBindAuthenticationHandler(this.connectionFactory);
            Authenticator auth = new Authenticator();
            auth.setDnResolver(dnResolver);
            auth.setAuthenticationHandler(bindAuthenticationHandler);
            AuthenticationResponse resp = auth.authenticate(new AuthenticationRequest(username, new Credential(password)));
            log.info("User " + username + " has tried to authenticate with result: " + resp.getAuthenticationResultCode());
            return resp.isSuccess();
        }
        catch (Exception e) {
            log.info("An error occurred while processing authentication request: " + e);
            return false;
        }
    }
}

