/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.ca;

import com.google.gson.Gson;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import net.jami.jams.ca.workers.crl.CRLWorker;
import net.jami.jams.ca.workers.crl.RevocationCallback;
import net.jami.jams.ca.workers.csr.CertificateWorker;
import net.jami.jams.ca.workers.ocsp.OCSPWorker;
import net.jami.jams.common.cryptoengineapi.CertificateAuthority;
import net.jami.jams.common.cryptoengineapi.CertificateAuthorityConfig;
import net.jami.jams.common.objects.devices.Device;
import net.jami.jams.common.objects.requests.RevocationRequest;
import net.jami.jams.common.objects.system.SystemAccount;
import net.jami.jams.common.objects.user.User;
import net.jami.jams.common.serialization.adapters.GsonFactory;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPReq;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JamsCA
implements CertificateAuthority,
RevocationCallback {
    private static final Logger log = LoggerFactory.getLogger(JamsCA.class);
    private static CRLWorker crlWorker;
    private static OCSPWorker ocspWorker;
    public static volatile String serverDomain;
    public static volatile String signingAlgorithm;
    public static long crlLifetime;
    public static long userLifetime;
    public static long deviceLifetime;
    public static SystemAccount CA;
    public static SystemAccount OCSP;
    public static boolean reverseProxy;
    private boolean revokeCompleted = false;
    private final Object lock = new Object();

    public void init(String settings, SystemAccount ca, SystemAccount ocsp) {
        X509Certificate cert;
        long caLifetime;
        Gson gson = GsonFactory.createGson();
        CertificateAuthorityConfig config = gson.fromJson(settings, CertificateAuthorityConfig.class);
        CA = ca;
        OCSP = ocsp;
        serverDomain = config.getServerDomain();
        signingAlgorithm = config.getSigningAlgorithm();
        crlLifetime = config.getCrlLifetime();
        userLifetime = config.getUserLifetime();
        deviceLifetime = config.getDeviceLifetime();
        reverseProxy = config.getReverseProxy();
        if (deviceLifetime > userLifetime) {
            log.warn("Device lifetime is greater than user lifetime, this is not recommended, please change this in the config file.");
        }
        if (userLifetime > (caLifetime = (cert = ca.getCertificate()).getNotAfter().getTime() - cert.getNotBefore().getTime())) {
            log.warn("User lifetime is greater than CA lifetime, this is not recommended, please change this in the config file.");
        }
        if (ca != null && ocsp != null) {
            crlWorker = new CRLWorker(CA.getPrivateKey(), CA.getCertificate());
            crlWorker.setRevocationCallback(this);
            try {
                ocspWorker = new OCSPWorker(OCSP.getPrivateKey(), OCSP.getCertificate(), crlWorker);
            }
            catch (Exception e) {
                log.error("An error occurred while starting OCSP request processor: {}", (Object)e.getMessage());
            }
        }
    }

    public User getSignedCertificate(User user) {
        return CertificateWorker.getSignedCertificate(user);
    }

    public User getRefreshedCertificate(User user) {
        return CertificateWorker.getRefreshedCertificate(user);
    }

    public Device getSignedCertificate(User user, Device device) {
        return CertificateWorker.getSignedCertificate(user, device);
    }

    public SystemAccount getSignedCertificate(SystemAccount systemAccount) {
        return CertificateWorker.getSignedCertificate(systemAccount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revokeCertificate(RevocationRequest revocationRequest) {
        crlWorker.getInput().add(revocationRequest);
        ConcurrentLinkedQueue concurrentLinkedQueue = crlWorker.getInput();
        synchronized (concurrentLinkedQueue) {
            crlWorker.getInput().notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRevocationCompleted() {
        this.revokeCompleted = true;
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void waitForRevokeCompletion() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            while (!this.revokeCompleted) {
                this.lock.wait();
            }
            this.revokeCompleted = false;
        }
    }

    public AtomicReference<X509CRLHolder> getLatestCRL() {
        return crlWorker.getExistingCRL();
    }

    public String getLatestCRLPEMEncoded() {
        try {
            return Base64.getEncoder().encodeToString(this.getLatestCRL().get().getEncoded());
        }
        catch (Exception e) {
            log.error("Unable to return a valid CRL!");
            return null;
        }
    }

    public static OCSPResp getOCSPResponse(OCSPReq ocspRequest, X509Certificate certificate, PrivateKey privateKey, Boolean unknown) throws OCSPException {
        return ocspWorker.getOCSPResponse(ocspRequest, certificate, privateKey, unknown);
    }

    public X509Certificate getCA() {
        return CA.getCertificate();
    }

    public boolean shutdownThreads() {
        crlWorker.getStop().set(true);
        crlWorker.interrupt();
        Thread.State state = crlWorker.getState();
        while (!state.equals((Object)Thread.State.TERMINATED)) {
            state = crlWorker.getState();
        }
        crlWorker = null;
        ocspWorker.stop();
        return true;
    }

    static {
        signingAlgorithm = "SHA512WITHRSA";
        crlLifetime = 360000000L;
        userLifetime = 360000000L;
        deviceLifetime = 360000000L;
        reverseProxy = false;
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

