/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl;

import com.unboundid.util.NotExtensible;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.LinkedHashSet;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;

@NotExtensible
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_THREADSAFE)
public abstract class WrapperKeyManager
extends X509ExtendedKeyManager {
    private final String certificateAlias;
    private final X509KeyManager[] keyManagers;

    protected WrapperKeyManager(KeyManager[] keyManagers, String certificateAlias) {
        this.certificateAlias = certificateAlias;
        this.keyManagers = new X509KeyManager[keyManagers.length];
        for (int i = 0; i < keyManagers.length; ++i) {
            this.keyManagers[i] = (X509KeyManager)keyManagers[i];
        }
    }

    protected WrapperKeyManager(X509KeyManager[] keyManagers, String certificateAlias) {
        this.keyManagers = keyManagers;
        this.certificateAlias = certificateAlias;
    }

    public String getCertificateAlias() {
        return this.certificateAlias;
    }

    @Override
    public final synchronized String[] getClientAliases(String keyType, Principal[] issuers) {
        LinkedHashSet<String> clientAliases = new LinkedHashSet<String>(StaticUtils.computeMapCapacity(10));
        for (X509KeyManager m3 : this.keyManagers) {
            String[] aliases = m3.getClientAliases(keyType, issuers);
            if (aliases == null) continue;
            clientAliases.addAll(Arrays.asList(aliases));
        }
        if (clientAliases.isEmpty()) {
            return null;
        }
        String[] aliases = new String[clientAliases.size()];
        return clientAliases.toArray(aliases);
    }

    @Override
    public final synchronized String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        if (this.certificateAlias == null) {
            for (X509KeyManager m3 : this.keyManagers) {
                String alias = m3.chooseClientAlias(keyType, issuers, socket);
                if (alias == null) continue;
                return alias;
            }
            return null;
        }
        for (String s2 : keyType) {
            for (X509KeyManager m4 : this.keyManagers) {
                String[] aliases = m4.getClientAliases(s2, issuers);
                if (aliases == null) continue;
                for (String alias : aliases) {
                    if (!alias.equals(this.certificateAlias)) continue;
                    return this.certificateAlias;
                }
            }
        }
        return null;
    }

    @Override
    public final synchronized String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine engine) {
        if (this.certificateAlias == null) {
            for (X509KeyManager m3 : this.keyManagers) {
                if (m3 instanceof X509ExtendedKeyManager) {
                    X509ExtendedKeyManager em = (X509ExtendedKeyManager)m3;
                    String alias = em.chooseEngineClientAlias(keyType, issuers, engine);
                    if (alias == null) continue;
                    return alias;
                }
                String alias = m3.chooseClientAlias(keyType, issuers, null);
                if (alias == null) continue;
                return alias;
            }
            return null;
        }
        for (String s2 : keyType) {
            for (X509KeyManager m4 : this.keyManagers) {
                String[] aliases = m4.getClientAliases(s2, issuers);
                if (aliases == null) continue;
                for (String alias : aliases) {
                    if (!alias.equals(this.certificateAlias)) continue;
                    return this.certificateAlias;
                }
            }
        }
        return null;
    }

    @Override
    public final synchronized String[] getServerAliases(String keyType, Principal[] issuers) {
        LinkedHashSet<String> serverAliases = new LinkedHashSet<String>(StaticUtils.computeMapCapacity(10));
        for (X509KeyManager m3 : this.keyManagers) {
            String[] aliases = m3.getServerAliases(keyType, issuers);
            if (aliases == null) continue;
            serverAliases.addAll(Arrays.asList(aliases));
        }
        if (serverAliases.isEmpty()) {
            return null;
        }
        String[] aliases = new String[serverAliases.size()];
        return serverAliases.toArray(aliases);
    }

    @Override
    public final synchronized String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        if (this.certificateAlias == null) {
            for (X509KeyManager m3 : this.keyManagers) {
                String alias = m3.chooseServerAlias(keyType, issuers, socket);
                if (alias == null) continue;
                return alias;
            }
            return null;
        }
        for (X509KeyManager m4 : this.keyManagers) {
            String[] aliases = m4.getServerAliases(keyType, issuers);
            if (aliases == null) continue;
            for (String alias : aliases) {
                if (!alias.equals(this.certificateAlias)) continue;
                return this.certificateAlias;
            }
        }
        return null;
    }

    @Override
    public final synchronized String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
        if (this.certificateAlias == null) {
            for (X509KeyManager m3 : this.keyManagers) {
                if (m3 instanceof X509ExtendedKeyManager) {
                    X509ExtendedKeyManager em = (X509ExtendedKeyManager)m3;
                    String alias = em.chooseEngineServerAlias(keyType, issuers, engine);
                    if (alias == null) continue;
                    return alias;
                }
                String alias = m3.chooseServerAlias(keyType, issuers, null);
                if (alias == null) continue;
                return alias;
            }
            return null;
        }
        for (X509KeyManager m4 : this.keyManagers) {
            String[] aliases = m4.getServerAliases(keyType, issuers);
            if (aliases == null) continue;
            for (String alias : aliases) {
                if (!alias.equals(this.certificateAlias)) continue;
                return this.certificateAlias;
            }
        }
        return null;
    }

    @Override
    public final synchronized X509Certificate[] getCertificateChain(String alias) {
        for (X509KeyManager m3 : this.keyManagers) {
            X509Certificate[] chain = m3.getCertificateChain(alias);
            if (chain == null) continue;
            return chain;
        }
        return null;
    }

    @Override
    public final synchronized PrivateKey getPrivateKey(String alias) {
        for (X509KeyManager m3 : this.keyManagers) {
            PrivateKey key = m3.getPrivateKey(alias);
            if (key == null) continue;
            return key;
        }
        return null;
    }
}

