/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.ssl.SSLSocketFactory;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class SynchronizedSSLSocketFactory
extends SSLSocketFactory {
    private final SSLSocketFactory factory;

    public SynchronizedSSLSocketFactory(SSLSocketFactory factory) {
        this.factory = factory;
    }

    public SSLSocketFactory getWrappedSocketFactory() {
        return this.factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Socket createSocket(String host, int port) throws IOException {
        SSLSocketFactory sSLSocketFactory = this.factory;
        synchronized (sSLSocketFactory) {
            return this.factory.createSocket(host, port);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort) throws IOException {
        SSLSocketFactory sSLSocketFactory = this.factory;
        synchronized (sSLSocketFactory) {
            return this.factory.createSocket(host, port, localAddress, localPort);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Socket createSocket(InetAddress address, int port) throws IOException {
        SSLSocketFactory sSLSocketFactory = this.factory;
        synchronized (sSLSocketFactory) {
            return this.factory.createSocket(address, port);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        SSLSocketFactory sSLSocketFactory = this.factory;
        synchronized (sSLSocketFactory) {
            return this.factory.createSocket(address, port, localAddress, localPort);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Socket createSocket(Socket s2, String host, int port, boolean autoClose) throws IOException {
        SSLSocketFactory sSLSocketFactory = this.factory;
        synchronized (sSLSocketFactory) {
            return this.factory.createSocket(s2, host, port, autoClose);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getDefaultCipherSuites() {
        SSLSocketFactory sSLSocketFactory = this.factory;
        synchronized (sSLSocketFactory) {
            return this.factory.getDefaultCipherSuites();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getSupportedCipherSuites() {
        SSLSocketFactory sSLSocketFactory = this.factory;
        synchronized (sSLSocketFactory) {
            return this.factory.getSupportedCipherSuites();
        }
    }
}

