/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Mutable;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.ReverseComparator;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ResultCodeCounter
implements Serializable {
    private static final long serialVersionUID = -2280620218815022241L;
    private final AtomicReference<ConcurrentHashMap<ResultCode, AtomicLong>> rcMap = new AtomicReference();

    public ResultCodeCounter() {
        this.rcMap.set(new ConcurrentHashMap(StaticUtils.computeMapCapacity(ResultCode.values().length)));
    }

    public void increment(ResultCode resultCode) {
        this.increment(resultCode, 1);
    }

    public void increment(ResultCode resultCode, int amount) {
        AtomicLong l2;
        ConcurrentHashMap<ResultCode, AtomicLong> m3 = this.rcMap.get();
        AtomicLong l = m3.get(resultCode);
        if (l == null && (l2 = m3.putIfAbsent(resultCode, l = new AtomicLong(0L))) != null) {
            l = l2;
        }
        l.addAndGet(amount);
    }

    public void reset() {
        this.rcMap.set(new ConcurrentHashMap(StaticUtils.computeMapCapacity(ResultCode.values().length)));
    }

    public List<ObjectPair<ResultCode, Long>> getCounts(boolean reset) {
        ConcurrentHashMap m3 = reset ? this.rcMap.getAndSet(new ConcurrentHashMap(StaticUtils.computeMapCapacity(ResultCode.values().length))) : new ConcurrentHashMap(this.rcMap.get());
        if (m3.isEmpty()) {
            return Collections.emptyList();
        }
        TreeMap sortedMap = new TreeMap(new ReverseComparator());
        for (Map.Entry e : m3.entrySet()) {
            long l = ((AtomicLong)e.getValue()).longValue();
            TreeMap<Integer, ResultCode> rcByValue = (TreeMap<Integer, ResultCode>)sortedMap.get(l);
            if (rcByValue == null) {
                rcByValue = new TreeMap<Integer, ResultCode>();
                sortedMap.put(l, rcByValue);
            }
            ResultCode rc = (ResultCode)e.getKey();
            rcByValue.put(rc.intValue(), rc);
        }
        ArrayList<ObjectPair<ResultCode, Long>> rcCounts = new ArrayList<ObjectPair<ResultCode, Long>>(2 * sortedMap.size());
        for (Map.Entry e : sortedMap.entrySet()) {
            long count = (Long)e.getKey();
            for (ResultCode rc : ((TreeMap)e.getValue()).values()) {
                rcCounts.add(new ObjectPair<ResultCode, Long>(rc, count));
            }
        }
        return Collections.unmodifiableList(rcCounts);
    }
}

