/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.util.NotExtensible;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotExtensible
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public abstract class LDAPSDKRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = -805259180160427851L;

    protected LDAPSDKRuntimeException(String message) {
        super(message);
    }

    protected LDAPSDKRuntimeException(String message, Throwable cause) {
        super(message, cause);
    }

    @Override
    public final String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append(super.toString());
    }

    public String getExceptionMessage() {
        boolean includeCause = Boolean.getBoolean("com.unboundid.ldap.sdk.debug.includeCauseInExceptionMessages");
        boolean includeStackTrace = Boolean.getBoolean("com.unboundid.ldap.sdk.debug.includeStackTraceInExceptionMessages");
        return this.getExceptionMessage(includeCause, includeStackTrace);
    }

    public String getExceptionMessage(boolean includeCause, boolean includeStackTrace) {
        Throwable cause;
        StringBuilder buffer = new StringBuilder();
        String message = this.getMessage();
        if (message == null || message.isEmpty()) {
            this.toString(buffer);
        } else {
            buffer.append(message);
        }
        if (includeStackTrace) {
            buffer.append(" stackTrace='");
            StaticUtils.getStackTrace(this, buffer);
        } else if (includeCause && (cause = this.getCause()) != null) {
            buffer.append(", cause=");
            buffer.append(StaticUtils.getExceptionMessage(cause));
        }
        String ldapSDKVersionString = ", ldapSDKVersion=5.0.1, revision=3290ee33d4aa17df1aadb4d814d6534375f395a9";
        if (buffer.indexOf(", ldapSDKVersion=5.0.1, revision=3290ee33d4aa17df1aadb4d814d6534375f395a9") < 0) {
            buffer.append(", ldapSDKVersion=5.0.1, revision=3290ee33d4aa17df1aadb4d814d6534375f395a9");
        }
        return buffer.toString();
    }
}

