/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.asn1.ASN1Buffer;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.ldap.protocol.LDAPResponse;
import com.unboundid.ldap.sdk.AbstractConnectionPool;
import com.unboundid.ldap.sdk.DisconnectType;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.InternalSDKHelper;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPRequest;
import com.unboundid.ldif.LDIFRecord;
import com.unboundid.util.DebugType;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONBuffer;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EnumSet;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class Debug
implements Serializable {
    public static final String PROPERTY_DEBUG_ENABLED = "com.unboundid.ldap.sdk.debug.enabled";
    public static final String PROPERTY_INCLUDE_STACK_TRACE = "com.unboundid.ldap.sdk.debug.includeStackTrace";
    public static final String PROPERTY_DEBUG_LEVEL = "com.unboundid.ldap.sdk.debug.level";
    public static final String PROPERTY_DEBUG_TYPE = "com.unboundid.ldap.sdk.debug.type";
    public static final String PROPERTY_INCLUDE_CAUSE_IN_EXCEPTION_MESSAGES = "com.unboundid.ldap.sdk.debug.includeCauseInExceptionMessages";
    public static final String PROPERTY_INCLUDE_STACK_TRACE_IN_EXCEPTION_MESSAGES = "com.unboundid.ldap.sdk.debug.includeStackTraceInExceptionMessages";
    public static final String LOGGER_NAME = "com.unboundid.ldap.sdk";
    private static final Logger logger = Logger.getLogger("com.unboundid.ldap.sdk");
    private static final ThreadLocal<SimpleDateFormat> TIMESTAMP_FORMATTERS = new ThreadLocal();
    private static final long serialVersionUID = -6079754380415146030L;
    private static boolean debugEnabled;
    private static boolean includeStackTrace;
    private static EnumSet<DebugType> debugTypes;

    private Debug() {
    }

    public static void initialize() {
        includeStackTrace = false;
        debugEnabled = false;
        debugTypes = EnumSet.allOf(DebugType.class);
        StaticUtils.setLoggerLevel(logger, Level.ALL);
    }

    public static void initialize(Properties properties) {
        String levelProp;
        String typesProp;
        String stackProp;
        Debug.initialize();
        if (properties == null || properties.isEmpty()) {
            return;
        }
        String enabledProp = properties.getProperty(PROPERTY_DEBUG_ENABLED);
        if (enabledProp != null && !enabledProp.isEmpty()) {
            if (enabledProp.equalsIgnoreCase("true")) {
                debugEnabled = true;
            } else if (enabledProp.equalsIgnoreCase("false")) {
                debugEnabled = false;
            } else {
                throw new IllegalArgumentException("Invalid value '" + enabledProp + "' for property " + PROPERTY_DEBUG_ENABLED + ".  The value must be either " + "'true' or 'false'.");
            }
        }
        if ((stackProp = properties.getProperty(PROPERTY_INCLUDE_STACK_TRACE)) != null && !stackProp.isEmpty()) {
            if (stackProp.equalsIgnoreCase("true")) {
                includeStackTrace = true;
            } else if (stackProp.equalsIgnoreCase("false")) {
                includeStackTrace = false;
            } else {
                throw new IllegalArgumentException("Invalid value '" + stackProp + "' for property " + PROPERTY_INCLUDE_STACK_TRACE + ".  The value must be either " + "'true' or 'false'.");
            }
        }
        if ((typesProp = properties.getProperty(PROPERTY_DEBUG_TYPE)) != null && !typesProp.isEmpty()) {
            debugTypes = EnumSet.noneOf(DebugType.class);
            StringTokenizer t = new StringTokenizer(typesProp, ", ");
            while (t.hasMoreTokens()) {
                String debugTypeName = t.nextToken();
                DebugType debugType = DebugType.forName(debugTypeName);
                if (debugType == null) {
                    throw new IllegalArgumentException("Invalid value '" + debugTypeName + "' for property " + PROPERTY_DEBUG_TYPE + ".  Allowed values include:  " + DebugType.getTypeNameList() + '.');
                }
                debugTypes.add(debugType);
            }
        }
        if ((levelProp = properties.getProperty(PROPERTY_DEBUG_LEVEL)) != null && !levelProp.isEmpty()) {
            StaticUtils.setLoggerLevel(logger, Level.parse(levelProp));
        }
    }

    public static Logger getLogger() {
        return logger;
    }

    public static boolean debugEnabled() {
        return debugEnabled;
    }

    public static boolean debugEnabled(DebugType debugType) {
        return debugEnabled && debugTypes.contains((Object)debugType);
    }

    public static void setEnabled(boolean enabled) {
        debugTypes = EnumSet.allOf(DebugType.class);
        debugEnabled = enabled;
    }

    public static void setEnabled(boolean enabled, Set<DebugType> types) {
        debugTypes = types == null || types.isEmpty() ? EnumSet.allOf(DebugType.class) : EnumSet.copyOf(types);
        debugEnabled = enabled;
    }

    public static boolean includeStackTrace() {
        return includeStackTrace;
    }

    public static void setIncludeStackTrace(boolean includeStackTrace) {
        Debug.includeStackTrace = includeStackTrace;
    }

    public static EnumSet<DebugType> getDebugTypes() {
        return debugTypes;
    }

    public static void debugException(Throwable t) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.EXCEPTION)) {
            Debug.debugException(Level.WARNING, t);
        }
    }

    public static void debugException(Level l, Throwable t) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.EXCEPTION)) {
            JSONBuffer buffer = new JSONBuffer();
            Debug.addCommonHeader(buffer, l, DebugType.EXCEPTION);
            Debug.addCaughtException(buffer, "caught-exception", t);
            Debug.addCommonFooter(buffer);
            Debug.log(l, buffer, t);
        }
    }

    public static void debugConnect(String h2, int p) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.CONNECT)) {
            Debug.debugConnect(Level.INFO, h2, p, null);
        }
    }

    public static void debugConnect(Level l, String h2, int p) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.CONNECT)) {
            Debug.debugConnect(l, h2, p, null);
        }
    }

    public static void debugConnect(String h2, int p, LDAPConnection c) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.CONNECT)) {
            Debug.debugConnect(Level.INFO, h2, p, c);
        }
    }

    public static void debugConnect(Level l, String h2, int p, LDAPConnection c) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.CONNECT)) {
            JSONBuffer buffer = new JSONBuffer();
            Debug.addCommonHeader(buffer, l, DebugType.CONNECT);
            buffer.appendString("connected-to-address", h2);
            buffer.appendNumber("connected-to-port", p);
            if (c != null) {
                String connectionPoolName;
                buffer.appendNumber("connection-id", c.getConnectionID());
                String connectionName = c.getConnectionName();
                if (connectionName != null) {
                    buffer.appendString("connection-name", connectionName);
                }
                if ((connectionPoolName = c.getConnectionPoolName()) != null) {
                    buffer.appendString("connection-pool-name", connectionPoolName);
                }
            }
            Debug.addCommonFooter(buffer);
            Debug.log(l, buffer);
        }
    }

    public static void debugDisconnect(String h2, int p, DisconnectType t, String m3, Throwable e) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.CONNECT)) {
            Debug.debugDisconnect(Level.INFO, h2, p, null, t, m3, e);
        }
    }

    public static void debugDisconnect(Level l, String h2, int p, DisconnectType t, String m3, Throwable e) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.CONNECT)) {
            Debug.debugDisconnect(l, h2, p, null, t, m3, e);
        }
    }

    public static void debugDisconnect(String h2, int p, LDAPConnection c, DisconnectType t, String m3, Throwable e) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.CONNECT)) {
            Debug.debugDisconnect(Level.INFO, h2, p, c, t, m3, e);
        }
    }

    public static void debugDisconnect(Level l, String h2, int p, LDAPConnection c, DisconnectType t, String m3, Throwable e) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.CONNECT)) {
            JSONBuffer buffer = new JSONBuffer();
            Debug.addCommonHeader(buffer, l, DebugType.CONNECT);
            if (c != null) {
                String connectionPoolName;
                buffer.appendNumber("connection-id", c.getConnectionID());
                String connectionName = c.getConnectionName();
                if (connectionName != null) {
                    buffer.appendString("connection-name", connectionName);
                }
                if ((connectionPoolName = c.getConnectionPoolName()) != null) {
                    buffer.appendString("connection-pool-name", connectionPoolName);
                }
                buffer.appendString("disconnected-from-address", h2);
                buffer.appendNumber("disconnected-from-port", p);
                buffer.appendString("disconnect-type", t.name());
                if (m3 != null) {
                    buffer.appendString("disconnect-message", m3);
                }
            }
            if (e != null) {
                Debug.addCaughtException(buffer, "disconnect-cause", e);
            }
            Debug.addCommonFooter(buffer);
            Debug.log(l, buffer, e);
        }
    }

    public static void debugLDAPRequest(LDAPRequest r) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.LDAP)) {
            Debug.debugLDAPRequest(Level.INFO, r, -1, null);
        }
    }

    public static void debugLDAPRequest(Level l, LDAPRequest r) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.LDAP)) {
            Debug.debugLDAPRequest(l, r, -1, null);
        }
    }

    public static void debugLDAPRequest(LDAPRequest r, int i, LDAPConnection c) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.LDAP)) {
            Debug.debugLDAPRequest(Level.INFO, r, i, c);
        }
    }

    public static void debugLDAPRequest(Level l, LDAPRequest r, int i, LDAPConnection c) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.LDAP)) {
            Debug.debugLDAPRequest(Level.INFO, String.valueOf(r), i, c);
        }
    }

    public static void debugLDAPRequest(Level l, String s2, int i, LDAPConnection c) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.LDAP)) {
            JSONBuffer buffer = new JSONBuffer();
            Debug.addCommonHeader(buffer, l, DebugType.LDAP);
            if (c != null) {
                String connectedAddress;
                String connectionPoolName;
                buffer.appendNumber("connection-id", c.getConnectionID());
                String connectionName = c.getConnectionName();
                if (connectionName != null) {
                    buffer.appendString("connection-name", connectionName);
                }
                if ((connectionPoolName = c.getConnectionPoolName()) != null) {
                    buffer.appendString("connection-pool-name", connectionPoolName);
                }
                if ((connectedAddress = c.getConnectedAddress()) != null) {
                    buffer.appendString("connected-to-address", connectedAddress);
                    buffer.appendNumber("connected-to-port", c.getConnectedPort());
                }
                try {
                    int soTimeout = InternalSDKHelper.getSoTimeout(c);
                    buffer.appendNumber("socket-timeout-millis", soTimeout);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (i >= 0) {
                buffer.appendNumber("message-id", i);
            }
            buffer.appendString("sending-ldap-request", s2);
            Debug.addCommonFooter(buffer);
            Debug.log(l, buffer);
        }
    }

    public static void debugLDAPResult(LDAPResponse r) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.LDAP)) {
            Debug.debugLDAPResult(Level.INFO, r, null);
        }
    }

    public static void debugLDAPResult(Level l, LDAPResponse r) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.LDAP)) {
            Debug.debugLDAPResult(l, r, null);
        }
    }

    public static void debugLDAPResult(LDAPResponse r, LDAPConnection c) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.LDAP)) {
            Debug.debugLDAPResult(Level.INFO, r, c);
        }
    }

    public static void debugLDAPResult(Level l, LDAPResponse r, LDAPConnection c) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.LDAP)) {
            JSONBuffer buffer = new JSONBuffer();
            Debug.addCommonHeader(buffer, l, DebugType.LDAP);
            if (c != null) {
                String connectedAddress;
                String connectionPoolName;
                buffer.appendNumber("connection-id", c.getConnectionID());
                String connectionName = c.getConnectionName();
                if (connectionName != null) {
                    buffer.appendString("connection-name", connectionName);
                }
                if ((connectionPoolName = c.getConnectionPoolName()) != null) {
                    buffer.appendString("connection-pool-name", connectionPoolName);
                }
                if ((connectedAddress = c.getConnectedAddress()) != null) {
                    buffer.appendString("connected-to-address", connectedAddress);
                    buffer.appendNumber("connected-to-port", c.getConnectedPort());
                }
            }
            buffer.appendString("read-ldap-result", r.toString());
            Debug.addCommonFooter(buffer);
            Debug.log(l, buffer);
        }
    }

    public static void debugASN1Write(ASN1Element e) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.ASN1)) {
            Debug.debugASN1Write(Level.INFO, e);
        }
    }

    public static void debugASN1Write(Level l, ASN1Element e) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.ASN1)) {
            JSONBuffer buffer = new JSONBuffer();
            Debug.addCommonHeader(buffer, l, DebugType.ASN1);
            buffer.appendString("writing-asn1-element", e.toString());
            Debug.addCommonFooter(buffer);
            Debug.log(l, buffer);
        }
    }

    public static void debugASN1Write(ASN1Buffer b) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.ASN1)) {
            Debug.debugASN1Write(Level.INFO, b);
        }
    }

    public static void debugASN1Write(Level l, ASN1Buffer b) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.ASN1)) {
            JSONBuffer buffer = new JSONBuffer();
            Debug.addCommonHeader(buffer, l, DebugType.ASN1);
            buffer.appendString("writing-asn1-element", StaticUtils.toHex(b.toByteArray()));
            Debug.addCommonFooter(buffer);
            Debug.log(l, buffer);
        }
    }

    public static void debugASN1Read(ASN1Element e) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.ASN1)) {
            Debug.debugASN1Read(Level.INFO, e);
        }
    }

    public static void debugASN1Read(Level l, ASN1Element e) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.ASN1)) {
            JSONBuffer buffer = new JSONBuffer();
            Debug.addCommonHeader(buffer, l, DebugType.ASN1);
            buffer.appendString("read-asn1-element", e.toString());
            Debug.addCommonFooter(buffer);
            Debug.log(l, buffer);
        }
    }

    public static void debugASN1Read(Level l, String dataType, int berType, int length, Object value) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.ASN1)) {
            JSONBuffer buffer = new JSONBuffer();
            Debug.addCommonHeader(buffer, l, DebugType.ASN1);
            buffer.beginObject("read-asn1-element");
            buffer.appendString("data-type", dataType);
            buffer.appendString("ber-type", StaticUtils.toHex((byte)(berType & 0xFF)));
            buffer.appendNumber("value-length", length);
            if (value != null) {
                if (value instanceof byte[]) {
                    buffer.appendString("value-bytes", StaticUtils.toHex((byte[])value));
                } else {
                    buffer.appendString("value-string", value.toString());
                }
            }
            buffer.endObject();
            Debug.addCommonFooter(buffer);
            Debug.log(l, buffer);
        }
    }

    public static void debugConnectionPool(Level l, AbstractConnectionPool p, LDAPConnection c, String m3, Throwable e) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.CONNECTION_POOL)) {
            long maxAvailable;
            long currentAvailable;
            JSONBuffer buffer = new JSONBuffer();
            Debug.addCommonHeader(buffer, l, DebugType.CONNECTION_POOL);
            String poolName = p.getConnectionPoolName();
            if (poolName == null) {
                buffer.appendNull("connection-pool-name");
            } else {
                buffer.appendString("connection-pool-name", poolName);
            }
            if (c != null) {
                buffer.appendNumber("connection-id", c.getConnectionID());
                String connectedAddress = c.getConnectedAddress();
                if (connectedAddress != null) {
                    buffer.appendString("connected-to-address", connectedAddress);
                    buffer.appendNumber("connected-to-port", c.getConnectedPort());
                }
            }
            if ((currentAvailable = (long)p.getCurrentAvailableConnections()) >= 0L) {
                buffer.appendNumber("current-available-connections", currentAvailable);
            }
            if ((maxAvailable = (long)p.getMaximumAvailableConnections()) >= 0L) {
                buffer.appendNumber("maximum-available-connections", maxAvailable);
            }
            if (m3 != null) {
                buffer.appendString("message", m3);
            }
            if (e != null) {
                Debug.addCaughtException(buffer, "caught-exception", e);
            }
            Debug.addCommonFooter(buffer);
            Debug.log(l, buffer, e);
        }
    }

    public static void debugLDIFWrite(LDIFRecord r) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.LDIF)) {
            Debug.debugLDIFWrite(Level.INFO, r);
        }
    }

    public static void debugLDIFWrite(Level l, LDIFRecord r) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.LDIF)) {
            JSONBuffer buffer = new JSONBuffer();
            Debug.addCommonHeader(buffer, l, DebugType.LDIF);
            buffer.appendString("writing-ldif-record", r.toString());
            Debug.addCommonFooter(buffer);
            Debug.log(l, buffer);
        }
    }

    public static void debugLDIFRead(LDIFRecord r) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.LDIF)) {
            Debug.debugLDIFRead(Level.INFO, r);
        }
    }

    public static void debugLDIFRead(Level l, LDIFRecord r) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.LDIF)) {
            JSONBuffer buffer = new JSONBuffer();
            Debug.addCommonHeader(buffer, l, DebugType.LDIF);
            buffer.appendString("read-ldif-record", r.toString());
            Debug.addCommonFooter(buffer);
            Debug.log(l, buffer);
        }
    }

    public static void debugMonitor(Entry e, String m3) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.MONITOR)) {
            Debug.debugMonitor(Level.FINE, e, m3);
        }
    }

    public static void debugMonitor(Level l, Entry e, String m3) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.MONITOR)) {
            JSONBuffer buffer = new JSONBuffer();
            Debug.addCommonHeader(buffer, l, DebugType.MONITOR);
            if (e != null) {
                buffer.appendString("monitor-entry-dn", e.getDN());
            }
            if (m3 != null) {
                buffer.appendString("message", m3);
            }
            Debug.addCommonFooter(buffer);
            Debug.log(l, buffer);
        }
    }

    public static void debugCodingError(Throwable t) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.CODING_ERROR)) {
            JSONBuffer buffer = new JSONBuffer();
            Debug.addCommonHeader(buffer, Level.SEVERE, DebugType.CODING_ERROR);
            Debug.addCaughtException(buffer, "coding-error", t);
            Debug.addCommonFooter(buffer);
            Debug.log(Level.SEVERE, buffer, t);
        }
    }

    public static void debug(Level l, DebugType t, String m3) {
        if (debugEnabled && debugTypes.contains((Object)t)) {
            JSONBuffer buffer = new JSONBuffer();
            Debug.addCommonHeader(buffer, l, t);
            if (m3 != null) {
                buffer.appendString("message", m3);
            }
            Debug.addCommonFooter(buffer);
            Debug.log(l, buffer);
        }
    }

    public static void debug(Level l, DebugType t, String m3, Throwable e) {
        if (debugEnabled && debugTypes.contains((Object)t)) {
            JSONBuffer buffer = new JSONBuffer();
            Debug.addCommonHeader(buffer, l, t);
            if (m3 != null) {
                buffer.appendString("message", m3);
            }
            if (e != null) {
                Debug.addCaughtException(buffer, "caught-exception", e);
            }
            Debug.addCommonFooter(buffer);
            Debug.log(l, buffer, e);
        }
    }

    private static void addCommonHeader(JSONBuffer buffer, Level level, DebugType type) {
        buffer.beginObject();
        buffer.appendString("timestamp", Debug.getTimestamp());
        buffer.appendString("debug-type", type.getName());
        buffer.appendString("level", level.getName());
        Thread t = Thread.currentThread();
        buffer.appendNumber("thread-id", t.getId());
        buffer.appendString("thread-name", t.getName());
    }

    private static String getTimestamp() {
        SimpleDateFormat timestampFormatter = TIMESTAMP_FORMATTERS.get();
        if (timestampFormatter == null) {
            timestampFormatter = new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH':'mm':'ss.SSS'Z'");
            timestampFormatter.setTimeZone(StaticUtils.getUTCTimeZone());
            TIMESTAMP_FORMATTERS.set(timestampFormatter);
        }
        return timestampFormatter.format(new Date());
    }

    private static String formatStackTraceFrame(StackTraceElement e) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(e.getMethodName());
        buffer.append('(');
        buffer.append(e.getFileName());
        int lineNumber = e.getLineNumber();
        if (lineNumber > 0) {
            buffer.append(':');
            buffer.append(lineNumber);
        } else if (e.isNativeMethod()) {
            buffer.append(":native");
        }
        buffer.append(')');
        return buffer.toString();
    }

    private static void addCaughtException(JSONBuffer buffer, String fieldName, Throwable t) {
        if (t == null) {
            return;
        }
        buffer.beginObject(fieldName);
        String message = t.getMessage();
        if (message != null) {
            buffer.appendString("message", t.getMessage());
        }
        buffer.beginArray("stack-trace");
        for (StackTraceElement e : t.getStackTrace()) {
            buffer.appendString(Debug.formatStackTraceFrame(e));
        }
        buffer.endArray();
        for (Throwable cause = t.getCause(); cause != null; cause = cause.getCause()) {
            buffer.beginObject("cause");
            message = cause.getMessage();
            if (message != null) {
                buffer.appendString("message", cause.getMessage());
            }
            buffer.beginArray("stack-trace");
            for (StackTraceElement e : cause.getStackTrace()) {
                buffer.appendString(Debug.formatStackTraceFrame(e));
            }
            buffer.endArray();
        }
        buffer.endObject();
    }

    private static void addCommonFooter(JSONBuffer buffer) {
        if (includeStackTrace) {
            buffer.beginArray("caller-stack-trace");
            boolean foundDebug = false;
            for (StackTraceElement e : Thread.currentThread().getStackTrace()) {
                String className = e.getClassName();
                if (className.equals(Debug.class.getName())) {
                    foundDebug = true;
                    continue;
                }
                if (!foundDebug) continue;
                buffer.appendString(Debug.formatStackTraceFrame(e));
            }
            buffer.endArray();
        }
        buffer.appendString("ldap-sdk-version", "5.0.1");
        buffer.appendString("ldap-sdk-revision", "3290ee33d4aa17df1aadb4d814d6534375f395a9");
        buffer.endObject();
    }

    private static void log(Level level, JSONBuffer buffer) {
        logger.log(level, buffer.toString());
    }

    private static void log(Level level, JSONBuffer buffer, Throwable thrown) {
        logger.log(level, buffer.toString(), thrown);
    }

    static {
        Debug.initialize(StaticUtils.getSystemProperties(PROPERTY_DEBUG_ENABLED, PROPERTY_DEBUG_LEVEL, PROPERTY_DEBUG_TYPE, PROPERTY_INCLUDE_STACK_TRACE));
    }
}

