/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs;

import com.unboundid.ldap.sdk.DereferencePolicy;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.unboundidds.logs.AccessLogOperationType;
import com.unboundid.ldap.sdk.unboundidds.logs.LogException;
import com.unboundid.ldap.sdk.unboundidds.logs.LogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.OperationRequestAccessLogMessage;
import com.unboundid.util.Debug;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

@NotExtensible
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public class SearchRequestAccessLogMessage
extends OperationRequestAccessLogMessage {
    private static final long serialVersionUID = -6751258649156129642L;
    private final Boolean typesOnly;
    private final DereferencePolicy derefPolicy;
    private final Integer sizeLimit;
    private final Integer timeLimit;
    private final List<String> requestedAttributes;
    private final SearchScope scope;
    private final String baseDN = this.getNamedValue("base");
    private final String filter = this.getNamedValue("filter");

    public SearchRequestAccessLogMessage(String s2) throws LogException {
        this(new LogMessage(s2));
    }

    public SearchRequestAccessLogMessage(LogMessage m3) {
        super(m3);
        this.sizeLimit = this.getNamedValueAsInteger("sizeLimit");
        this.timeLimit = this.getNamedValueAsInteger("timeLimit");
        this.typesOnly = this.getNamedValueAsBoolean("typesOnly");
        SearchScope ss = null;
        try {
            ss = SearchScope.definedValueOf(this.getNamedValueAsInteger("scope"));
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        this.scope = ss;
        DereferencePolicy deref = null;
        String derefStr = this.getNamedValue("deref");
        if (derefStr != null) {
            for (DereferencePolicy p : DereferencePolicy.values()) {
                if (!p.getName().equalsIgnoreCase(derefStr)) continue;
                deref = p;
                break;
            }
        }
        this.derefPolicy = deref;
        String attrStr = this.getNamedValue("attrs");
        if (attrStr == null) {
            this.requestedAttributes = null;
        } else if (attrStr.equals("ALL")) {
            this.requestedAttributes = Collections.emptyList();
        } else {
            LinkedList<String> attrs = new LinkedList<String>();
            StringTokenizer st = new StringTokenizer(attrStr, ",", false);
            while (st.hasMoreTokens()) {
                attrs.add(st.nextToken());
            }
            this.requestedAttributes = Collections.unmodifiableList(attrs);
        }
    }

    public final String getBaseDN() {
        return this.baseDN;
    }

    public final SearchScope getScope() {
        return this.scope;
    }

    public final String getFilter() {
        return this.filter;
    }

    public final Filter getParsedFilter() {
        try {
            if (this.filter == null) {
                return null;
            }
            return Filter.create(this.filter);
        }
        catch (Exception e) {
            Debug.debugException(e);
            return null;
        }
    }

    public final DereferencePolicy getDereferencePolicy() {
        return this.derefPolicy;
    }

    public final Integer getSizeLimit() {
        return this.sizeLimit;
    }

    public final Integer getTimeLimit() {
        return this.timeLimit;
    }

    public final Boolean typesOnly() {
        return this.typesOnly;
    }

    public final List<String> getRequestedAttributes() {
        return this.requestedAttributes;
    }

    @Override
    public final AccessLogOperationType getOperationType() {
        return AccessLogOperationType.SEARCH;
    }
}

