/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs;

import com.unboundid.ldap.sdk.unboundidds.logs.AccessLogMessageType;
import com.unboundid.ldap.sdk.unboundidds.logs.LogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.OperationAccessLogMessage;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

@NotExtensible
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public abstract class OperationRequestAccessLogMessage
extends OperationAccessLogMessage {
    private static final long serialVersionUID = -8942685623238040482L;
    private final Boolean usingAdminSessionWorkerThread;
    private final List<String> requestControlOIDs;
    private final String intermediateClientRequest = this.getNamedValue("via");
    private final String operationPurpose = this.getNamedValue("opPurpose");
    private final String requesterDN = this.getNamedValue("requesterDN");
    private final String requesterIP = this.getNamedValue("requesterIP");

    protected OperationRequestAccessLogMessage(LogMessage m3) {
        super(m3);
        this.usingAdminSessionWorkerThread = this.getNamedValueAsBoolean("usingAdminSessionWorkerThread");
        String controlStr = this.getNamedValue("requestControls");
        if (controlStr == null) {
            this.requestControlOIDs = Collections.emptyList();
        } else {
            LinkedList<String> controlList = new LinkedList<String>();
            StringTokenizer t = new StringTokenizer(controlStr, ",");
            while (t.hasMoreTokens()) {
                controlList.add(t.nextToken());
            }
            this.requestControlOIDs = Collections.unmodifiableList(controlList);
        }
    }

    public final String getRequesterDN() {
        return this.requesterDN;
    }

    public final String getRequesterIPAddress() {
        return this.requesterIP;
    }

    public final String getIntermediateClientRequest() {
        return this.intermediateClientRequest;
    }

    public final String getOperationPurpose() {
        return this.operationPurpose;
    }

    public final List<String> getRequestControlOIDs() {
        return this.requestControlOIDs;
    }

    public final Boolean usingAdminSessionWorkerThread() {
        return this.usingAdminSessionWorkerThread;
    }

    @Override
    public AccessLogMessageType getMessageType() {
        return AccessLogMessageType.REQUEST;
    }
}

