/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.ChangeType;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ModificationType;
import com.unboundid.ldap.sdk.RDN;
import com.unboundid.ldap.sdk.unboundidds.logs.AuditLogException;
import com.unboundid.ldap.sdk.unboundidds.logs.AuditLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.LogMessages;
import com.unboundid.ldap.sdk.unboundidds.logs.ModifyAuditLogMessage;
import com.unboundid.ldif.LDIFChangeRecord;
import com.unboundid.ldif.LDIFException;
import com.unboundid.ldif.LDIFModifyChangeRecord;
import com.unboundid.ldif.LDIFModifyDNChangeRecord;
import com.unboundid.ldif.LDIFReader;
import com.unboundid.util.Debug;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ModifyDNAuditLogMessage
extends AuditLogMessage {
    private static final long serialVersionUID = 3954476664207635518L;
    private final LDIFModifyDNChangeRecord modifyDNChangeRecord;
    private final List<Modification> attributeModifications;

    public ModifyDNAuditLogMessage(String ... logMessageLines) throws AuditLogException {
        this(StaticUtils.toList(logMessageLines), logMessageLines);
    }

    public ModifyDNAuditLogMessage(List<String> logMessageLines) throws AuditLogException {
        this(logMessageLines, StaticUtils.toArray(logMessageLines, String.class));
    }

    private ModifyDNAuditLogMessage(List<String> logMessageLineList, String[] logMessageLineArray) throws AuditLogException {
        super(logMessageLineList);
        try {
            LDIFChangeRecord changeRecord = LDIFReader.decodeChangeRecord(logMessageLineArray);
            if (!(changeRecord instanceof LDIFModifyDNChangeRecord)) {
                throw new AuditLogException(logMessageLineList, LogMessages.ERR_MODIFY_DN_AUDIT_LOG_MESSAGE_CHANGE_TYPE_NOT_MODIFY_DN.get(changeRecord.getChangeType().getName(), ChangeType.MODIFY_DN.getName()));
            }
            this.modifyDNChangeRecord = (LDIFModifyDNChangeRecord)changeRecord;
        }
        catch (LDIFException e) {
            Debug.debugException(e);
            throw new AuditLogException(logMessageLineList, LogMessages.ERR_MODIFY_DN_AUDIT_LOG_MESSAGE_LINES_NOT_CHANGE_RECORD.get(StaticUtils.getExceptionMessage(e)), e);
        }
        this.attributeModifications = ModifyDNAuditLogMessage.decodeAttributeModifications(logMessageLineList, this.modifyDNChangeRecord);
    }

    ModifyDNAuditLogMessage(List<String> logMessageLines, LDIFModifyDNChangeRecord modifyDNChangeRecord) throws AuditLogException {
        super(logMessageLines);
        this.modifyDNChangeRecord = modifyDNChangeRecord;
        this.attributeModifications = ModifyDNAuditLogMessage.decodeAttributeModifications(logMessageLines, modifyDNChangeRecord);
    }

    private static List<Modification> decodeAttributeModifications(List<String> logMessageLines, LDIFModifyDNChangeRecord modifyDNChangeRecord) {
        ArrayList<String> ldifLines = null;
        for (String line : logMessageLines) {
            if (!line.startsWith("# ")) break;
            String uncommentedLine = line.substring(2);
            if (ldifLines == null) {
                String lowerLine = StaticUtils.toLowerCase(uncommentedLine);
                if (!lowerLine.startsWith("modifydn attribute modifications")) continue;
                ldifLines = new ArrayList<String>(logMessageLines.size());
                continue;
            }
            if (ldifLines.isEmpty()) {
                ldifLines.add("dn: " + modifyDNChangeRecord.getDN());
                ldifLines.add("changetype: modify");
            }
            ldifLines.add(uncommentedLine);
        }
        if (ldifLines == null) {
            return null;
        }
        if (ldifLines.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            String[] ldifLineArray = ldifLines.toArray(StaticUtils.NO_STRINGS);
            LDIFModifyChangeRecord changeRecord = (LDIFModifyChangeRecord)LDIFReader.decodeChangeRecord(ldifLineArray);
            return Collections.unmodifiableList(Arrays.asList(changeRecord.getModifications()));
        }
        catch (Exception e) {
            Debug.debugException(e);
            return null;
        }
    }

    @Override
    public String getDN() {
        return this.modifyDNChangeRecord.getDN();
    }

    public String getNewRDN() {
        return this.modifyDNChangeRecord.getNewRDN();
    }

    public boolean deleteOldRDN() {
        return this.modifyDNChangeRecord.deleteOldRDN();
    }

    public String getNewSuperiorDN() {
        return this.modifyDNChangeRecord.getNewSuperiorDN();
    }

    public List<Modification> getAttributeModifications() {
        return this.attributeModifications;
    }

    @Override
    public ChangeType getChangeType() {
        return ChangeType.MODIFY_DN;
    }

    @Override
    public LDIFModifyDNChangeRecord getChangeRecord() {
        return this.modifyDNChangeRecord;
    }

    @Override
    public boolean isRevertible() {
        RDN newRDN;
        RDN oldRDN;
        try {
            DN parsedDN = this.modifyDNChangeRecord.getParsedDN();
            oldRDN = parsedDN.getRDN();
            if (oldRDN == null) {
                return false;
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
            return false;
        }
        try {
            DN newDN = this.modifyDNChangeRecord.getNewDN();
            newRDN = this.modifyDNChangeRecord.getParsedNewRDN();
        }
        catch (Exception e) {
            Debug.debugException(e);
            return false;
        }
        if (this.attributeModifications == null) {
            return false;
        }
        if (this.attributeModifications.isEmpty() && this.modifyDNChangeRecord.deleteOldRDN() && !newRDN.equals(oldRDN)) {
            return false;
        }
        for (Modification m3 : this.attributeModifications) {
            if (ModifyAuditLogMessage.modificationIsRevertible(m3)) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<LDIFChangeRecord> getRevertChangeRecords() throws AuditLogException {
        boolean revertedDeleteOldRDN;
        RDN newRDN;
        DN newSuperiorDN;
        DN originalDN;
        DN newDN;
        if (this.attributeModifications == null) {
            throw new AuditLogException(this.getLogMessageLines(), LogMessages.ERR_MODIFY_DN_NOT_REVERTIBLE.get(this.modifyDNChangeRecord.getDN()));
        }
        try {
            newDN = this.modifyDNChangeRecord.getNewDN();
            originalDN = this.modifyDNChangeRecord.getParsedDN();
            newSuperiorDN = this.modifyDNChangeRecord.getParsedNewSuperiorDN();
            newRDN = this.modifyDNChangeRecord.getParsedNewRDN();
        }
        catch (Exception e) {
            Debug.debugException(e);
            if (this.modifyDNChangeRecord.getNewSuperiorDN() == null) {
                throw new AuditLogException(this.getLogMessageLines(), LogMessages.ERR_MODIFY_DN_CANNOT_GET_NEW_DN_WITHOUT_NEW_SUPERIOR.get(this.modifyDNChangeRecord.getDN(), this.modifyDNChangeRecord.getNewRDN()), e);
            }
            throw new AuditLogException(this.getLogMessageLines(), LogMessages.ERR_MODIFY_DN_CANNOT_GET_NEW_DN_WITH_NEW_SUPERIOR.get(this.modifyDNChangeRecord.getDN(), this.modifyDNChangeRecord.getNewRDN(), this.modifyDNChangeRecord.getNewSuperiorDN()), e);
        }
        if (originalDN.isNullDN()) {
            throw new AuditLogException(this.getLogMessageLines(), LogMessages.ERR_MODIFY_DN_CANNOT_REVERT_NULL_DN.get());
        }
        if (this.attributeModifications.isEmpty() && this.modifyDNChangeRecord.deleteOldRDN() && !newRDN.equals(originalDN.getRDN())) {
            throw new AuditLogException(this.getLogMessageLines(), LogMessages.ERR_MODIFY_DN_CANNOT_REVERT_WITHOUT_NECESSARY_MODS.get(this.modifyDNChangeRecord.getDN()));
        }
        String revertedDN = newDN.toString();
        String revertedNewRDN = originalDN.getRDNString();
        String revertedNewSuperiorDN = newSuperiorDN == null ? null : originalDN.getParentString();
        if (this.attributeModifications.isEmpty()) {
            return Collections.singletonList(new LDIFModifyDNChangeRecord(revertedDN, revertedNewRDN, false, revertedNewSuperiorDN));
        }
        int numNewRDNs = newRDN.getAttributeNames().length;
        HashSet<ObjectPair<String, byte[]>> addedNewRDNValues = new HashSet<ObjectPair<String, byte[]>>(StaticUtils.computeMapCapacity(numNewRDNs));
        RDN originalRDN = originalDN.getRDN();
        ArrayList<Modification> additionalModifications = new ArrayList<Modification>(this.attributeModifications.size());
        int numModifications = this.attributeModifications.size();
        for (int i = numModifications - 1; i >= 0; --i) {
            byte[] valueBytes;
            ArrayList<byte[]> retainedValues;
            Modification m3 = this.attributeModifications.get(i);
            if (m3.getModificationType() == ModificationType.ADD) {
                Attribute attribute = m3.getAttribute();
                retainedValues = new ArrayList<byte[]>(attribute.size());
                for (ASN1OctetString value : attribute.getRawValues()) {
                    valueBytes = value.getValue();
                    if (newRDN.hasAttributeValue(attribute.getName(), valueBytes)) {
                        addedNewRDNValues.add(new ObjectPair<String, byte[]>(attribute.getName(), valueBytes));
                        continue;
                    }
                    retainedValues.add(valueBytes);
                }
                if (retainedValues.size() == attribute.size()) {
                    additionalModifications.add(new Modification(ModificationType.DELETE, attribute.getName(), attribute.getRawValues()));
                    continue;
                }
                if (retainedValues.isEmpty()) continue;
                additionalModifications.add(new Modification(ModificationType.DELETE, attribute.getName(), StaticUtils.toArray(retainedValues, byte[].class)));
                continue;
            }
            if (m3.getModificationType() == ModificationType.DELETE) {
                Attribute attribute = m3.getAttribute();
                retainedValues = new ArrayList(attribute.size());
                for (ASN1OctetString value : attribute.getRawValues()) {
                    valueBytes = value.getValue();
                    if (originalRDN.hasAttributeValue(attribute.getName(), valueBytes)) continue;
                    retainedValues.add(valueBytes);
                }
                if (retainedValues.size() == attribute.size()) {
                    additionalModifications.add(new Modification(ModificationType.ADD, attribute.getName(), attribute.getRawValues()));
                    continue;
                }
                if (retainedValues.isEmpty()) continue;
                additionalModifications.add(new Modification(ModificationType.ADD, attribute.getName(), StaticUtils.toArray(retainedValues, byte[].class)));
                continue;
            }
            Modification modification = ModifyAuditLogMessage.getRevertModification(m3);
            if (modification == null) {
                throw new AuditLogException(this.getLogMessageLines(), LogMessages.ERR_MODIFY_DN_MOD_NOT_REVERTIBLE.get(this.modifyDNChangeRecord.getDN(), m3.getModificationType().getName(), m3.getAttributeName()));
            }
            additionalModifications.add(modification);
        }
        if (addedNewRDNValues.size() == numNewRDNs) {
            revertedDeleteOldRDN = true;
        } else {
            revertedDeleteOldRDN = false;
            if (!addedNewRDNValues.isEmpty()) {
                for (ObjectPair objectPair : addedNewRDNValues) {
                    additionalModifications.add(0, new Modification(ModificationType.DELETE, (String)objectPair.getFirst(), (byte[])objectPair.getSecond()));
                }
            }
        }
        ArrayList<LDIFChangeRecord> changeRecords = new ArrayList<LDIFChangeRecord>(2);
        changeRecords.add(new LDIFModifyDNChangeRecord(revertedDN, revertedNewRDN, revertedDeleteOldRDN, revertedNewSuperiorDN));
        if (!additionalModifications.isEmpty()) {
            changeRecords.add(new LDIFModifyChangeRecord(originalDN.toString(), (List<Modification>)additionalModifications));
        }
        return Collections.unmodifiableList(changeRecords);
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append(this.getUncommentedHeaderLine());
        buffer.append("; changeType=modify-dn; dn=\"");
        buffer.append(this.modifyDNChangeRecord.getDN());
        buffer.append("\", newRDN=\"");
        buffer.append(this.modifyDNChangeRecord.getNewRDN());
        buffer.append("\", deleteOldRDN=");
        buffer.append(this.modifyDNChangeRecord.deleteOldRDN());
        String newSuperiorDN = this.modifyDNChangeRecord.getNewSuperiorDN();
        if (newSuperiorDN != null) {
            buffer.append(", newSuperiorDN=\"");
            buffer.append(newSuperiorDN);
            buffer.append('\"');
        }
    }
}

