/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs;

import com.unboundid.ldap.sdk.ChangeType;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ModificationType;
import com.unboundid.ldap.sdk.unboundidds.logs.AuditLogException;
import com.unboundid.ldap.sdk.unboundidds.logs.AuditLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.LogMessages;
import com.unboundid.ldif.LDIFChangeRecord;
import com.unboundid.ldif.LDIFException;
import com.unboundid.ldif.LDIFModifyChangeRecord;
import com.unboundid.ldif.LDIFReader;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ModifyAuditLogMessage
extends AuditLogMessage {
    private static final long serialVersionUID = -5262466264778465574L;
    private final Boolean isSoftDeletedEntry;
    private final LDIFModifyChangeRecord modifyChangeRecord;

    public ModifyAuditLogMessage(String ... logMessageLines) throws AuditLogException {
        this(StaticUtils.toList(logMessageLines), logMessageLines);
    }

    public ModifyAuditLogMessage(List<String> logMessageLines) throws AuditLogException {
        this(logMessageLines, StaticUtils.toArray(logMessageLines, String.class));
    }

    private ModifyAuditLogMessage(List<String> logMessageLineList, String[] logMessageLineArray) throws AuditLogException {
        super(logMessageLineList);
        try {
            LDIFChangeRecord changeRecord = LDIFReader.decodeChangeRecord(logMessageLineArray);
            if (!(changeRecord instanceof LDIFModifyChangeRecord)) {
                throw new AuditLogException(logMessageLineList, LogMessages.ERR_MODIFY_AUDIT_LOG_MESSAGE_CHANGE_TYPE_NOT_MODIFY.get(changeRecord.getChangeType().getName(), ChangeType.MODIFY.getName()));
            }
            this.modifyChangeRecord = (LDIFModifyChangeRecord)changeRecord;
        }
        catch (LDIFException e) {
            Debug.debugException(e);
            throw new AuditLogException(logMessageLineList, LogMessages.ERR_MODIFY_AUDIT_LOG_MESSAGE_LINES_NOT_CHANGE_RECORD.get(StaticUtils.getExceptionMessage(e)), e);
        }
        this.isSoftDeletedEntry = ModifyAuditLogMessage.getNamedValueAsBoolean("isSoftDeletedEntry", this.getHeaderNamedValues());
    }

    ModifyAuditLogMessage(List<String> logMessageLines, LDIFModifyChangeRecord modifyChangeRecord) throws AuditLogException {
        super(logMessageLines);
        this.modifyChangeRecord = modifyChangeRecord;
        this.isSoftDeletedEntry = ModifyAuditLogMessage.getNamedValueAsBoolean("isSoftDeletedEntry", this.getHeaderNamedValues());
    }

    @Override
    public String getDN() {
        return this.modifyChangeRecord.getDN();
    }

    public List<Modification> getModifications() {
        return Collections.unmodifiableList(Arrays.asList(this.modifyChangeRecord.getModifications()));
    }

    public Boolean getIsSoftDeletedEntry() {
        return this.isSoftDeletedEntry;
    }

    @Override
    public ChangeType getChangeType() {
        return ChangeType.MODIFY;
    }

    @Override
    public LDIFModifyChangeRecord getChangeRecord() {
        return this.modifyChangeRecord;
    }

    @Override
    public boolean isRevertible() {
        for (Modification m3 : this.modifyChangeRecord.getModifications()) {
            if (ModifyAuditLogMessage.modificationIsRevertible(m3)) continue;
            return false;
        }
        return true;
    }

    static boolean modificationIsRevertible(Modification m3) {
        switch (m3.getModificationType().intValue()) {
            case 0: 
            case 3: {
                return true;
            }
            case 1: {
                return m3.hasValue();
            }
        }
        return false;
    }

    static Modification getRevertModification(Modification m3) {
        switch (m3.getModificationType().intValue()) {
            case 0: {
                return new Modification(ModificationType.DELETE, m3.getAttributeName(), m3.getRawValues());
            }
            case 3: {
                String firstValue = m3.getValues()[0];
                if (firstValue.startsWith("-")) {
                    return new Modification(ModificationType.INCREMENT, m3.getAttributeName(), firstValue.substring(1));
                }
                return new Modification(ModificationType.INCREMENT, m3.getAttributeName(), '-' + firstValue);
            }
            case 1: {
                if (m3.hasValue()) {
                    return new Modification(ModificationType.ADD, m3.getAttributeName(), m3.getRawValues());
                }
                return null;
            }
        }
        return null;
    }

    @Override
    public List<LDIFChangeRecord> getRevertChangeRecords() throws AuditLogException {
        Modification[] mods = this.modifyChangeRecord.getModifications();
        Modification[] revertMods = new Modification[mods.length];
        int i = mods.length - 1;
        int j = 0;
        while (i >= 0) {
            revertMods[j] = ModifyAuditLogMessage.getRevertModification(mods[i]);
            if (revertMods[j] == null) {
                throw new AuditLogException(this.getLogMessageLines(), LogMessages.ERR_MODIFY_AUDIT_LOG_MESSAGE_MOD_NOT_REVERTIBLE.get(this.modifyChangeRecord.getDN(), String.valueOf(mods[i])));
            }
            --i;
            ++j;
        }
        return Collections.singletonList(new LDIFModifyChangeRecord(this.modifyChangeRecord.getDN(), revertMods));
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append(this.getUncommentedHeaderLine());
        buffer.append("; changeType=modify; dn=\"");
        buffer.append(this.modifyChangeRecord.getDN());
        buffer.append('\"');
    }
}

