/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs;

import com.unboundid.ldap.sdk.unboundidds.logs.AccessLogMessageType;
import com.unboundid.ldap.sdk.unboundidds.logs.AccessLogOperationType;
import com.unboundid.ldap.sdk.unboundidds.logs.LogException;
import com.unboundid.ldap.sdk.unboundidds.logs.LogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.OperationRequestAccessLogMessage;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class IntermediateResponseAccessLogMessage
extends OperationRequestAccessLogMessage {
    private static final long serialVersionUID = 4480365381503945078L;
    private final AccessLogOperationType operationType;
    private final List<String> responseControlOIDs;
    private final String name;
    private final String oid = this.getNamedValue("oid");
    private final String value;

    public IntermediateResponseAccessLogMessage(String s2) throws LogException {
        this(new LogMessage(s2));
    }

    public IntermediateResponseAccessLogMessage(LogMessage m3) {
        super(m3);
        this.name = this.getNamedValue("name");
        this.value = this.getNamedValue("value");
        String controlStr = this.getNamedValue("responseControls");
        if (controlStr == null) {
            this.responseControlOIDs = Collections.emptyList();
        } else {
            LinkedList<String> controlList = new LinkedList<String>();
            StringTokenizer t = new StringTokenizer(controlStr, ",");
            while (t.hasMoreTokens()) {
                controlList.add(t.nextToken());
            }
            this.responseControlOIDs = Collections.unmodifiableList(controlList);
        }
        this.operationType = m3.hasUnnamedValue(AccessLogOperationType.ADD.getLogIdentifier()) ? AccessLogOperationType.ADD : (m3.hasUnnamedValue(AccessLogOperationType.BIND.getLogIdentifier()) ? AccessLogOperationType.BIND : (m3.hasUnnamedValue(AccessLogOperationType.COMPARE.getLogIdentifier()) ? AccessLogOperationType.COMPARE : (m3.hasUnnamedValue(AccessLogOperationType.DELETE.getLogIdentifier()) ? AccessLogOperationType.DELETE : (m3.hasUnnamedValue(AccessLogOperationType.EXTENDED.getLogIdentifier()) ? AccessLogOperationType.EXTENDED : (m3.hasUnnamedValue(AccessLogOperationType.MODIFY.getLogIdentifier()) ? AccessLogOperationType.MODIFY : (m3.hasUnnamedValue(AccessLogOperationType.MODDN.getLogIdentifier()) ? AccessLogOperationType.MODDN : (m3.hasUnnamedValue(AccessLogOperationType.SEARCH.getLogIdentifier()) ? AccessLogOperationType.SEARCH : AccessLogOperationType.EXTENDED)))))));
    }

    public String getOID() {
        return this.oid;
    }

    public String getIntermediateResponseName() {
        return this.name;
    }

    public String getValueString() {
        return this.value;
    }

    public List<String> getResponseControlOIDs() {
        return this.responseControlOIDs;
    }

    @Override
    public AccessLogMessageType getMessageType() {
        return AccessLogMessageType.INTERMEDIATE_RESPONSE;
    }

    @Override
    public AccessLogOperationType getOperationType() {
        return this.operationType;
    }
}

