/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.jsonfilter;

import com.unboundid.ldap.sdk.unboundidds.jsonfilter.JFMessages;
import com.unboundid.ldap.sdk.unboundidds.jsonfilter.JSONObjectFilter;
import com.unboundid.util.Debug;
import com.unboundid.util.Mutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import com.unboundid.util.json.JSONArray;
import com.unboundid.util.json.JSONException;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONString;
import com.unboundid.util.json.JSONValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class ObjectMatchesJSONObjectFilter
extends JSONObjectFilter {
    public static final String FILTER_TYPE = "objectMatches";
    public static final String FIELD_FIELD_PATH = "field";
    public static final String FIELD_FILTER = "filter";
    private static final Set<String> REQUIRED_FIELD_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("field", "filter")));
    private static final Set<String> OPTIONAL_FIELD_NAMES = Collections.emptySet();
    private static final long serialVersionUID = 7138078723547160420L;
    private volatile JSONObjectFilter filter;
    private volatile List<String> field;

    ObjectMatchesJSONObjectFilter() {
        this.field = null;
        this.filter = null;
    }

    public ObjectMatchesJSONObjectFilter(String field, JSONObjectFilter filter) {
        this(Collections.singletonList(field), filter);
    }

    public ObjectMatchesJSONObjectFilter(List<String> field, JSONObjectFilter filter) {
        Validator.ensureNotNull(field);
        Validator.ensureFalse(field.isEmpty());
        Validator.ensureNotNull(filter);
        this.field = Collections.unmodifiableList(new ArrayList<String>(field));
        this.filter = filter;
    }

    public List<String> getField() {
        return this.field;
    }

    public void setField(String ... field) {
        this.setField(StaticUtils.toList(field));
    }

    public void setField(List<String> field) {
        Validator.ensureNotNull(field);
        Validator.ensureFalse(field.isEmpty());
        this.field = Collections.unmodifiableList(new ArrayList<String>(field));
    }

    public JSONObjectFilter getFilter() {
        return this.filter;
    }

    public void setFilter(JSONObjectFilter filter) {
        Validator.ensureNotNull(filter);
        this.filter = filter;
    }

    @Override
    public String getFilterType() {
        return FILTER_TYPE;
    }

    @Override
    protected Set<String> getRequiredFieldNames() {
        return REQUIRED_FIELD_NAMES;
    }

    @Override
    protected Set<String> getOptionalFieldNames() {
        return OPTIONAL_FIELD_NAMES;
    }

    @Override
    public boolean matchesJSONObject(JSONObject o) {
        List<JSONValue> candidates = ObjectMatchesJSONObjectFilter.getValues(o, this.field);
        if (candidates.isEmpty()) {
            return false;
        }
        for (JSONValue v : candidates) {
            if (v instanceof JSONObject) {
                if (!this.filter.matchesJSONObject((JSONObject)v)) continue;
                return true;
            }
            if (!(v instanceof JSONArray)) continue;
            for (JSONValue arrayValue : ((JSONArray)v).getValues()) {
                if (!(arrayValue instanceof JSONObject) || !this.filter.matchesJSONObject((JSONObject)arrayValue)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public JSONObject toJSONObject() {
        LinkedHashMap<String, JSONValue> fields = new LinkedHashMap<String, JSONValue>(StaticUtils.computeMapCapacity(3));
        fields.put("filterType", new JSONString(FILTER_TYPE));
        if (this.field.size() == 1) {
            fields.put(FIELD_FIELD_PATH, new JSONString(this.field.get(0)));
        } else {
            ArrayList<JSONString> fieldNameValues = new ArrayList<JSONString>(this.field.size());
            for (String s2 : this.field) {
                fieldNameValues.add(new JSONString(s2));
            }
            fields.put(FIELD_FIELD_PATH, new JSONArray(fieldNameValues));
        }
        fields.put(FIELD_FILTER, this.filter.toJSONObject());
        return new JSONObject(fields);
    }

    @Override
    protected ObjectMatchesJSONObjectFilter decodeFilter(JSONObject filterObject) throws JSONException {
        List<String> fieldPath = this.getStrings(filterObject, FIELD_FIELD_PATH, false, null);
        JSONValue v = filterObject.getField(FIELD_FILTER);
        if (v == null) {
            throw new JSONException(JFMessages.ERR_OBJECT_FILTER_MISSING_REQUIRED_FIELD.get(String.valueOf(filterObject), FILTER_TYPE, FIELD_FILTER));
        }
        if (!(v instanceof JSONObject)) {
            throw new JSONException(JFMessages.ERR_OBJECT_FILTER_VALUE_NOT_OBJECT.get(String.valueOf(filterObject), FILTER_TYPE, FIELD_FILTER));
        }
        try {
            return new ObjectMatchesJSONObjectFilter(fieldPath, JSONObjectFilter.decode((JSONObject)v));
        }
        catch (JSONException e) {
            Debug.debugException(e);
            throw new JSONException(JFMessages.ERR_OBJECT_FILTER_VALUE_NOT_FILTER.get(String.valueOf(filterObject), FILTER_TYPE, FIELD_FILTER, e.getMessage()), e);
        }
    }
}

