/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.jsonfilter;

import com.unboundid.ldap.sdk.unboundidds.jsonfilter.ExpectedValueType;
import com.unboundid.ldap.sdk.unboundidds.jsonfilter.JFMessages;
import com.unboundid.ldap.sdk.unboundidds.jsonfilter.JSONObjectFilter;
import com.unboundid.util.Mutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import com.unboundid.util.json.JSONArray;
import com.unboundid.util.json.JSONBoolean;
import com.unboundid.util.json.JSONException;
import com.unboundid.util.json.JSONNull;
import com.unboundid.util.json.JSONNumber;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONString;
import com.unboundid.util.json.JSONValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class ContainsFieldJSONObjectFilter
extends JSONObjectFilter {
    public static final String FILTER_TYPE = "containsField";
    public static final String FIELD_FIELD_PATH = "field";
    public static final String FIELD_EXPECTED_TYPE = "expectedType";
    private static final Set<String> REQUIRED_FIELD_NAMES = Collections.unmodifiableSet(new HashSet<String>(Collections.singletonList("field")));
    private static final Set<String> OPTIONAL_FIELD_NAMES = Collections.unmodifiableSet(new HashSet<String>(Collections.singletonList("expectedType")));
    private static final Set<ExpectedValueType> ALL_EXPECTED_VALUE_TYPES = Collections.unmodifiableSet(EnumSet.allOf(ExpectedValueType.class));
    private static final long serialVersionUID = -2922149221350606755L;
    private volatile List<String> field;
    private volatile Set<ExpectedValueType> expectedValueTypes;

    ContainsFieldJSONObjectFilter() {
        this.field = null;
        this.expectedValueTypes = null;
    }

    private ContainsFieldJSONObjectFilter(List<String> field, Set<ExpectedValueType> expectedValueTypes) {
        this.field = field;
        this.expectedValueTypes = expectedValueTypes;
    }

    public ContainsFieldJSONObjectFilter(String ... field) {
        this(StaticUtils.toList(field));
    }

    public ContainsFieldJSONObjectFilter(List<String> field) {
        Validator.ensureNotNull(field);
        Validator.ensureFalse(field.isEmpty());
        this.field = Collections.unmodifiableList(new ArrayList<String>(field));
        this.expectedValueTypes = ALL_EXPECTED_VALUE_TYPES;
    }

    public List<String> getField() {
        return this.field;
    }

    public void setField(String ... field) {
        this.setField(StaticUtils.toList(field));
    }

    public void setField(List<String> field) {
        Validator.ensureNotNull(field);
        Validator.ensureFalse(field.isEmpty());
        this.field = Collections.unmodifiableList(new ArrayList<String>(field));
    }

    public Set<ExpectedValueType> getExpectedType() {
        return this.expectedValueTypes;
    }

    public void setExpectedType(ExpectedValueType ... expectedTypes) {
        this.setExpectedType(StaticUtils.toList(expectedTypes));
    }

    public void setExpectedType(Collection<ExpectedValueType> expectedTypes) {
        if (expectedTypes == null || expectedTypes.isEmpty()) {
            this.expectedValueTypes = ALL_EXPECTED_VALUE_TYPES;
        } else {
            EnumSet<ExpectedValueType> s2 = EnumSet.noneOf(ExpectedValueType.class);
            s2.addAll(expectedTypes);
            this.expectedValueTypes = Collections.unmodifiableSet(s2);
        }
    }

    @Override
    public String getFilterType() {
        return FILTER_TYPE;
    }

    @Override
    protected Set<String> getRequiredFieldNames() {
        return REQUIRED_FIELD_NAMES;
    }

    @Override
    protected Set<String> getOptionalFieldNames() {
        return OPTIONAL_FIELD_NAMES;
    }

    @Override
    public boolean matchesJSONObject(JSONObject o) {
        List<JSONValue> candidates = ContainsFieldJSONObjectFilter.getValues(o, this.field);
        if (candidates.isEmpty()) {
            return false;
        }
        for (JSONValue v : candidates) {
            JSONArray a;
            if (!(v instanceof JSONArray ? ((a = (JSONArray)v).isEmpty() ? this.expectedValueTypes.contains((Object)ExpectedValueType.EMPTY_ARRAY) : this.expectedValueTypes.contains((Object)ExpectedValueType.NON_EMPTY_ARRAY)) : (v instanceof JSONBoolean ? this.expectedValueTypes.contains((Object)ExpectedValueType.BOOLEAN) : (v instanceof JSONNull ? this.expectedValueTypes.contains((Object)ExpectedValueType.NULL) : (v instanceof JSONNumber ? this.expectedValueTypes.contains((Object)ExpectedValueType.NUMBER) : (v instanceof JSONObject ? this.expectedValueTypes.contains((Object)ExpectedValueType.OBJECT) : v instanceof JSONString && this.expectedValueTypes.contains((Object)ExpectedValueType.STRING))))))) continue;
            return true;
        }
        return false;
    }

    @Override
    public JSONObject toJSONObject() {
        LinkedHashMap<String, JSONValue> fields = new LinkedHashMap<String, JSONValue>(StaticUtils.computeMapCapacity(3));
        fields.put("filterType", new JSONString(FILTER_TYPE));
        if (this.field.size() == 1) {
            fields.put(FIELD_FIELD_PATH, new JSONString(this.field.get(0)));
        } else {
            ArrayList<JSONString> fieldNameValues = new ArrayList<JSONString>(this.field.size());
            for (String s2 : this.field) {
                fieldNameValues.add(new JSONString(s2));
            }
            fields.put(FIELD_FIELD_PATH, new JSONArray(fieldNameValues));
        }
        if (!this.expectedValueTypes.equals(ALL_EXPECTED_VALUE_TYPES)) {
            if (this.expectedValueTypes.size() == 1) {
                fields.put(FIELD_EXPECTED_TYPE, new JSONString(this.expectedValueTypes.iterator().next().toString()));
            } else {
                ArrayList<JSONString> expectedTypeValues = new ArrayList<JSONString>(this.expectedValueTypes.size());
                for (ExpectedValueType t : this.expectedValueTypes) {
                    expectedTypeValues.add(new JSONString(t.toString()));
                }
                fields.put(FIELD_EXPECTED_TYPE, new JSONArray(expectedTypeValues));
            }
        }
        return new JSONObject(fields);
    }

    @Override
    protected ContainsFieldJSONObjectFilter decodeFilter(JSONObject filterObject) throws JSONException {
        Set<ExpectedValueType> expectedTypes;
        List<String> fieldPath = this.getStrings(filterObject, FIELD_FIELD_PATH, false, null);
        List<String> valueTypeNames = this.getStrings(filterObject, FIELD_EXPECTED_TYPE, false, Collections.emptyList());
        if (valueTypeNames.isEmpty()) {
            expectedTypes = ALL_EXPECTED_VALUE_TYPES;
        } else {
            EnumSet<ExpectedValueType> valueTypes = EnumSet.noneOf(ExpectedValueType.class);
            for (String s2 : valueTypeNames) {
                ExpectedValueType t = ExpectedValueType.forName(s2);
                if (t == null) {
                    throw new JSONException(JFMessages.ERR_CONTAINS_FIELD_FILTER_UNRECOGNIZED_EXPECTED_TYPE.get(String.valueOf(filterObject), FILTER_TYPE, s2, FIELD_EXPECTED_TYPE));
                }
                valueTypes.add(t);
            }
            expectedTypes = valueTypes;
        }
        return new ContainsFieldJSONObjectFilter(fieldPath, expectedTypes);
    }
}

