/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Enumerated;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.ldap.sdk.unboundidds.controls.SuppressType;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class SuppressOperationalAttributeUpdateRequestControl
extends Control {
    public static final String SUPPRESS_OP_ATTR_UPDATE_REQUEST_OID = "1.3.6.1.4.1.30221.2.5.27";
    private static final byte TYPE_SUPPRESS_TYPES = -128;
    private static final long serialVersionUID = 4603958484615351672L;
    private final Set<SuppressType> suppressTypes;

    public SuppressOperationalAttributeUpdateRequestControl(SuppressType ... suppressTypes) {
        this(false, suppressTypes);
    }

    public SuppressOperationalAttributeUpdateRequestControl(Collection<SuppressType> suppressTypes) {
        this(false, suppressTypes);
    }

    public SuppressOperationalAttributeUpdateRequestControl(boolean isCritical, SuppressType ... suppressTypes) {
        this(isCritical, Arrays.asList(suppressTypes));
    }

    public SuppressOperationalAttributeUpdateRequestControl(boolean isCritical, Collection<SuppressType> suppressTypes) {
        super(SUPPRESS_OP_ATTR_UPDATE_REQUEST_OID, isCritical, SuppressOperationalAttributeUpdateRequestControl.encodeValue(suppressTypes));
        Validator.ensureFalse(suppressTypes.isEmpty());
        EnumSet<SuppressType> s2 = EnumSet.noneOf(SuppressType.class);
        for (SuppressType t : suppressTypes) {
            s2.add(t);
        }
        this.suppressTypes = Collections.unmodifiableSet(s2);
    }

    public SuppressOperationalAttributeUpdateRequestControl(Control control) throws LDAPException {
        super(control);
        ASN1OctetString value = control.getValue();
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_SUPPRESS_OP_ATTR_UPDATE_REQUEST_MISSING_VALUE.get());
        }
        try {
            ASN1Sequence valueSequence = ASN1Sequence.decodeAsSequence(value.getValue());
            ASN1Sequence suppressTypesSequence = ASN1Sequence.decodeAsSequence(valueSequence.elements()[0]);
            EnumSet<SuppressType> s2 = EnumSet.noneOf(SuppressType.class);
            for (ASN1Element e : suppressTypesSequence.elements()) {
                ASN1Enumerated ae = ASN1Enumerated.decodeAsEnumerated(e);
                SuppressType t = SuppressType.valueOf(ae.intValue());
                if (t == null) {
                    throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_SUPPRESS_OP_ATTR_UNRECOGNIZED_SUPPRESS_TYPE.get(ae.intValue()));
                }
                s2.add(t);
            }
            this.suppressTypes = Collections.unmodifiableSet(s2);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_SUPPRESS_OP_ATTR_UPDATE_REQUEST_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    private static ASN1OctetString encodeValue(Collection<SuppressType> suppressTypes) {
        ArrayList<ASN1Enumerated> suppressTypeElements = new ArrayList<ASN1Enumerated>(suppressTypes.size());
        for (SuppressType t : suppressTypes) {
            suppressTypeElements.add(new ASN1Enumerated(t.intValue()));
        }
        ASN1Sequence valueSequence = new ASN1Sequence(new ASN1Sequence(-128, suppressTypeElements));
        return new ASN1OctetString(valueSequence.encode());
    }

    public Set<SuppressType> getSuppressTypes() {
        return this.suppressTypes;
    }

    @Override
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_SUPPRESS_OP_ATTR_UPDATE_REQUEST.get();
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("SuppressOperationalAttributeUpdateRequestControl(isCritical=");
        buffer.append(this.isCritical());
        buffer.append(", suppressTypes={");
        Iterator<SuppressType> iterator = this.suppressTypes.iterator();
        while (iterator.hasNext()) {
            buffer.append(iterator.next().name());
            if (!iterator.hasNext()) continue;
            buffer.append(',');
        }
        buffer.append("})");
    }
}

