/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.migrate.ldapjdk;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.migrate.ldapjdk.IterableEnumeration;
import com.unboundid.util.Mutable;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Set;

@NotExtensible
@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public class LDAPAttribute
implements Serializable {
    private static final long serialVersionUID = 839217229050750570L;
    private Attribute attribute;

    public LDAPAttribute(Attribute attr) {
        this.attribute = attr;
    }

    public LDAPAttribute(LDAPAttribute attr) {
        this.attribute = attr.attribute;
    }

    public LDAPAttribute(String attrName) {
        this.attribute = new Attribute(attrName);
    }

    public LDAPAttribute(String attrName, byte[] attrBytes) {
        this.attribute = new Attribute(attrName, attrBytes);
    }

    public LDAPAttribute(String attrName, String attrString) {
        this.attribute = new Attribute(attrName, attrString);
    }

    public LDAPAttribute(String attrName, String[] attrStrings) {
        this.attribute = new Attribute(attrName, attrStrings);
    }

    public String getName() {
        return this.attribute.getName();
    }

    public String getBaseName() {
        return this.attribute.getBaseName();
    }

    public static String getBaseName(String attrName) {
        return Attribute.getBaseName(attrName);
    }

    public String[] getSubtypes() {
        Set<String> optionSet = this.attribute.getOptions();
        if (optionSet.isEmpty()) {
            return null;
        }
        String[] options = new String[optionSet.size()];
        return optionSet.toArray(options);
    }

    public static String[] getSubtypes(String attrName) {
        return new LDAPAttribute(attrName).getSubtypes();
    }

    public String getLangSubtype() {
        for (String s2 : this.attribute.getOptions()) {
            String lowerName = StaticUtils.toLowerCase(s2);
            if (!lowerName.startsWith("lang-")) continue;
            return s2;
        }
        return null;
    }

    public boolean hasSubtype(String subtype) {
        return this.attribute.hasOption(subtype);
    }

    public boolean hasSubtypes(String[] subtypes) {
        for (String s2 : subtypes) {
            if (this.attribute.hasOption(s2)) continue;
            return false;
        }
        return true;
    }

    public Enumeration<String> getStringValues() {
        return new IterableEnumeration<String>(Arrays.asList(this.attribute.getValues()));
    }

    public String[] getStringValueArray() {
        return this.attribute.getValues();
    }

    public Enumeration<byte[]> getByteValues() {
        return new IterableEnumeration<byte[]>(Arrays.asList(this.attribute.getValueByteArrays()));
    }

    public byte[][] getByteValueArray() {
        return this.attribute.getValueByteArrays();
    }

    public void addValue(String attrString) {
        this.attribute = Attribute.mergeAttributes(this.attribute, new Attribute(this.attribute.getName(), attrString));
    }

    public void addValue(byte[] attrBytes) {
        this.attribute = Attribute.mergeAttributes(this.attribute, new Attribute(this.attribute.getName(), attrBytes));
    }

    public void removeValue(String attrValue) {
        this.attribute = Attribute.removeValues(this.attribute, new Attribute(this.attribute.getName(), attrValue));
    }

    public void removeValue(byte[] attrValue) {
        this.attribute = Attribute.removeValues(this.attribute, new Attribute(this.attribute.getName(), attrValue));
    }

    public int size() {
        return this.attribute.size();
    }

    public final Attribute toAttribute() {
        return this.attribute;
    }

    public String toString() {
        return this.attribute.toString();
    }
}

