/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.controls;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.controls.ControlMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class MatchedValuesFilter
implements Serializable {
    public static final byte MATCH_TYPE_EQUALITY = -93;
    public static final byte MATCH_TYPE_SUBSTRINGS = -92;
    public static final byte MATCH_TYPE_GREATER_OR_EQUAL = -91;
    public static final byte MATCH_TYPE_LESS_OR_EQUAL = -90;
    public static final byte MATCH_TYPE_PRESENT = -121;
    public static final byte MATCH_TYPE_APPROXIMATE = -88;
    public static final byte MATCH_TYPE_EXTENSIBLE = -87;
    private static final byte SUBSTRING_TYPE_SUBINITIAL = -128;
    private static final byte SUBSTRING_TYPE_SUBANY = -127;
    private static final byte SUBSTRING_TYPE_SUBFINAL = -126;
    private static final byte EXTENSIBLE_TYPE_MATCHING_RULE_ID = -127;
    private static final byte EXTENSIBLE_TYPE_ATTRIBUTE_NAME = -126;
    private static final byte EXTENSIBLE_TYPE_MATCH_VALUE = -125;
    private static final ASN1OctetString[] NO_SUB_ANY = new ASN1OctetString[0];
    private static final String[] NO_SUB_ANY_STRINGS = StaticUtils.NO_STRINGS;
    private static final byte[][] NO_SUB_ANY_BYTES = new byte[0][];
    private static final long serialVersionUID = 8144732301100674661L;
    private final ASN1OctetString assertionValue;
    private final ASN1OctetString subFinalValue;
    private final ASN1OctetString subInitialValue;
    private final ASN1OctetString[] subAnyValues;
    private final byte matchType;
    private final String attributeType;
    private final String matchingRuleID;

    private MatchedValuesFilter(byte matchType, String attributeType, ASN1OctetString assertionValue, ASN1OctetString subInitialValue, ASN1OctetString[] subAnyValues, ASN1OctetString subFinalValue, String matchingRuleID) {
        this.matchType = matchType;
        this.attributeType = attributeType;
        this.assertionValue = assertionValue;
        this.subInitialValue = subInitialValue;
        this.subAnyValues = subAnyValues;
        this.subFinalValue = subFinalValue;
        this.matchingRuleID = matchingRuleID;
    }

    public static MatchedValuesFilter createEqualityFilter(String attributeType, String assertionValue) {
        Validator.ensureNotNull(attributeType, assertionValue);
        return new MatchedValuesFilter(-93, attributeType, new ASN1OctetString(assertionValue), null, NO_SUB_ANY, null, null);
    }

    public static MatchedValuesFilter createEqualityFilter(String attributeType, byte[] assertionValue) {
        Validator.ensureNotNull(attributeType, assertionValue);
        return new MatchedValuesFilter(-93, attributeType, new ASN1OctetString(assertionValue), null, NO_SUB_ANY, null, null);
    }

    public static MatchedValuesFilter createSubstringFilter(String attributeType, String subInitialValue, String[] subAnyValues, String subFinalValue) {
        ASN1OctetString[] subAnyOS;
        Validator.ensureNotNull(attributeType);
        Validator.ensureTrue(subInitialValue != null || subAnyValues != null && subAnyValues.length > 0 || subFinalValue != null);
        ASN1OctetString subInitialOS = subInitialValue == null ? null : new ASN1OctetString(-128, subInitialValue);
        if (subAnyValues == null || subAnyValues.length == 0) {
            subAnyOS = NO_SUB_ANY;
        } else {
            subAnyOS = new ASN1OctetString[subAnyValues.length];
            for (int i = 0; i < subAnyValues.length; ++i) {
                subAnyOS[i] = new ASN1OctetString(-127, subAnyValues[i]);
            }
        }
        ASN1OctetString subFinalOS = subFinalValue == null ? null : new ASN1OctetString(-126, subFinalValue);
        return new MatchedValuesFilter(-92, attributeType, null, subInitialOS, subAnyOS, subFinalOS, null);
    }

    public static MatchedValuesFilter createSubstringFilter(String attributeType, byte[] subInitialValue, byte[][] subAnyValues, byte[] subFinalValue) {
        ASN1OctetString[] subAnyOS;
        Validator.ensureNotNull(attributeType);
        Validator.ensureTrue(subInitialValue != null || subAnyValues != null && subAnyValues.length > 0 || subFinalValue != null);
        ASN1OctetString subInitialOS = subInitialValue == null ? null : new ASN1OctetString(-128, subInitialValue);
        if (subAnyValues == null || subAnyValues.length == 0) {
            subAnyOS = NO_SUB_ANY;
        } else {
            subAnyOS = new ASN1OctetString[subAnyValues.length];
            for (int i = 0; i < subAnyValues.length; ++i) {
                subAnyOS[i] = new ASN1OctetString(-127, subAnyValues[i]);
            }
        }
        ASN1OctetString subFinalOS = subFinalValue == null ? null : new ASN1OctetString(-126, subFinalValue);
        return new MatchedValuesFilter(-92, attributeType, null, subInitialOS, subAnyOS, subFinalOS, null);
    }

    public static MatchedValuesFilter createGreaterOrEqualFilter(String attributeType, String assertionValue) {
        Validator.ensureNotNull(attributeType, assertionValue);
        return new MatchedValuesFilter(-91, attributeType, new ASN1OctetString(assertionValue), null, NO_SUB_ANY, null, null);
    }

    public static MatchedValuesFilter createGreaterOrEqualFilter(String attributeType, byte[] assertionValue) {
        Validator.ensureNotNull(attributeType, assertionValue);
        return new MatchedValuesFilter(-91, attributeType, new ASN1OctetString(assertionValue), null, NO_SUB_ANY, null, null);
    }

    public static MatchedValuesFilter createLessOrEqualFilter(String attributeType, String assertionValue) {
        Validator.ensureNotNull(attributeType, assertionValue);
        return new MatchedValuesFilter(-90, attributeType, new ASN1OctetString(assertionValue), null, NO_SUB_ANY, null, null);
    }

    public static MatchedValuesFilter createLessOrEqualFilter(String attributeType, byte[] assertionValue) {
        Validator.ensureNotNull(attributeType, assertionValue);
        return new MatchedValuesFilter(-90, attributeType, new ASN1OctetString(assertionValue), null, NO_SUB_ANY, null, null);
    }

    public static MatchedValuesFilter createPresentFilter(String attributeType) {
        Validator.ensureNotNull(attributeType);
        return new MatchedValuesFilter(-121, attributeType, null, null, NO_SUB_ANY, null, null);
    }

    public static MatchedValuesFilter createApproximateFilter(String attributeType, String assertionValue) {
        Validator.ensureNotNull(attributeType, assertionValue);
        return new MatchedValuesFilter(-88, attributeType, new ASN1OctetString(assertionValue), null, NO_SUB_ANY, null, null);
    }

    public static MatchedValuesFilter createApproximateFilter(String attributeType, byte[] assertionValue) {
        Validator.ensureNotNull(attributeType, assertionValue);
        return new MatchedValuesFilter(-88, attributeType, new ASN1OctetString(assertionValue), null, NO_SUB_ANY, null, null);
    }

    public static MatchedValuesFilter createExtensibleMatchFilter(String attributeType, String matchingRuleID, String assertionValue) {
        Validator.ensureNotNull(assertionValue);
        Validator.ensureTrue(attributeType != null || matchingRuleID != null);
        ASN1OctetString matchValue = new ASN1OctetString(-125, assertionValue);
        return new MatchedValuesFilter(-87, attributeType, matchValue, null, NO_SUB_ANY, null, matchingRuleID);
    }

    public static MatchedValuesFilter createExtensibleMatchFilter(String attributeType, String matchingRuleID, byte[] assertionValue) {
        Validator.ensureNotNull(assertionValue);
        Validator.ensureTrue(attributeType != null || matchingRuleID != null);
        ASN1OctetString matchValue = new ASN1OctetString(-125, assertionValue);
        return new MatchedValuesFilter(-87, attributeType, matchValue, null, NO_SUB_ANY, null, matchingRuleID);
    }

    public static MatchedValuesFilter create(Filter filter) throws LDAPException {
        switch (filter.getFilterType()) {
            case -96: {
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_MV_FILTER_AND_NOT_SUPPORTED.get());
            }
            case -95: {
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_MV_FILTER_OR_NOT_SUPPORTED.get());
            }
            case -94: {
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_MV_FILTER_NOT_NOT_SUPPORTED.get());
            }
            case -93: {
                return MatchedValuesFilter.createEqualityFilter(filter.getAttributeName(), filter.getAssertionValueBytes());
            }
            case -92: {
                return MatchedValuesFilter.createSubstringFilter(filter.getAttributeName(), filter.getSubInitialBytes(), filter.getSubAnyBytes(), filter.getSubFinalBytes());
            }
            case -91: {
                return MatchedValuesFilter.createGreaterOrEqualFilter(filter.getAttributeName(), filter.getAssertionValueBytes());
            }
            case -90: {
                return MatchedValuesFilter.createLessOrEqualFilter(filter.getAttributeName(), filter.getAssertionValueBytes());
            }
            case -121: {
                return MatchedValuesFilter.createPresentFilter(filter.getAttributeName());
            }
            case -88: {
                return MatchedValuesFilter.createApproximateFilter(filter.getAttributeName(), filter.getAssertionValueBytes());
            }
            case -87: {
                if (filter.getDNAttributes()) {
                    throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_MV_FILTER_DNATTRS_NOT_SUPPORTED.get());
                }
                return MatchedValuesFilter.createExtensibleMatchFilter(filter.getAttributeName(), filter.getMatchingRuleID(), filter.getAssertionValueBytes());
            }
        }
        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_MV_FILTER_INVALID_FILTER_TYPE.get(StaticUtils.toHex(filter.getFilterType())));
    }

    public byte getMatchType() {
        return this.matchType;
    }

    public String getAttributeType() {
        return this.attributeType;
    }

    public String getAssertionValue() {
        if (this.assertionValue == null) {
            return null;
        }
        return this.assertionValue.stringValue();
    }

    public byte[] getAssertionValueBytes() {
        if (this.assertionValue == null) {
            return null;
        }
        return this.assertionValue.getValue();
    }

    public ASN1OctetString getRawAssertionValue() {
        return this.assertionValue;
    }

    public String getSubInitialValue() {
        if (this.subInitialValue == null) {
            return null;
        }
        return this.subInitialValue.stringValue();
    }

    public byte[] getSubInitialValueBytes() {
        if (this.subInitialValue == null) {
            return null;
        }
        return this.subInitialValue.getValue();
    }

    public ASN1OctetString getRawSubInitialValue() {
        return this.subInitialValue;
    }

    public String[] getSubAnyValues() {
        if (this.subAnyValues.length == 0) {
            return NO_SUB_ANY_STRINGS;
        }
        String[] subAnyStrings = new String[this.subAnyValues.length];
        for (int i = 0; i < this.subAnyValues.length; ++i) {
            subAnyStrings[i] = this.subAnyValues[i].stringValue();
        }
        return subAnyStrings;
    }

    public byte[][] getSubAnyValueBytes() {
        if (this.subAnyValues.length == 0) {
            return NO_SUB_ANY_BYTES;
        }
        byte[][] subAnyBytes = new byte[this.subAnyValues.length][];
        for (int i = 0; i < this.subAnyValues.length; ++i) {
            subAnyBytes[i] = this.subAnyValues[i].getValue();
        }
        return subAnyBytes;
    }

    public ASN1OctetString[] getRawSubAnyValues() {
        return this.subAnyValues;
    }

    public String getSubFinalValue() {
        if (this.subFinalValue == null) {
            return null;
        }
        return this.subFinalValue.stringValue();
    }

    public byte[] getSubFinalValueBytes() {
        if (this.subFinalValue == null) {
            return null;
        }
        return this.subFinalValue.getValue();
    }

    public ASN1OctetString getRawSubFinalValue() {
        return this.subFinalValue;
    }

    public String getMatchingRuleID() {
        return this.matchingRuleID;
    }

    public ASN1Element encode() {
        switch (this.matchType) {
            case -93: 
            case -91: 
            case -90: 
            case -88: {
                ASN1Element[] elements = new ASN1Element[]{new ASN1OctetString(this.attributeType), this.assertionValue};
                return new ASN1Sequence(this.matchType, elements);
            }
            case -92: {
                ArrayList<ASN1OctetString> subElements = new ArrayList<ASN1OctetString>(3);
                if (this.subInitialValue != null) {
                    subElements.add(this.subInitialValue);
                }
                if (this.subAnyValues.length > 0) {
                    subElements.addAll(Arrays.asList(this.subAnyValues));
                }
                if (this.subFinalValue != null) {
                    subElements.add(this.subFinalValue);
                }
                ASN1Element[] elements = new ASN1Element[]{new ASN1OctetString(this.attributeType), new ASN1Sequence(subElements)};
                return new ASN1Sequence(this.matchType, elements);
            }
            case -121: {
                return new ASN1OctetString(this.matchType, this.attributeType);
            }
            case -87: {
                ArrayList<ASN1OctetString> extElements = new ArrayList<ASN1OctetString>(3);
                if (this.attributeType != null) {
                    extElements.add(new ASN1OctetString(-126, this.attributeType));
                }
                if (this.matchingRuleID != null) {
                    extElements.add(new ASN1OctetString(-127, this.matchingRuleID));
                }
                extElements.add(this.assertionValue);
                return new ASN1Sequence(this.matchType, extElements);
            }
        }
        return null;
    }

    public static MatchedValuesFilter decode(ASN1Element element) throws LDAPException {
        ASN1OctetString assertionValue = null;
        ASN1OctetString subInitialValue = null;
        ASN1OctetString subFinalValue = null;
        ASN1OctetString[] subAnyValues = NO_SUB_ANY;
        byte matchType = element.getType();
        String attributeType = null;
        String matchingRuleID = null;
        switch (matchType) {
            case -93: 
            case -91: 
            case -90: 
            case -88: {
                try {
                    ASN1Element[] elements = ASN1Sequence.decodeAsSequence(element).elements();
                    attributeType = ASN1OctetString.decodeAsOctetString(elements[0]).stringValue();
                    assertionValue = ASN1OctetString.decodeAsOctetString(elements[1]);
                    break;
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_MV_FILTER_NOT_AVA.get(e), e);
                }
            }
            case -92: {
                try {
                    ASN1Element[] subElements;
                    ASN1Element[] elements = ASN1Sequence.decodeAsSequence(element).elements();
                    attributeType = ASN1OctetString.decodeAsOctetString(elements[0]).stringValue();
                    ArrayList<ASN1OctetString> subAnyList = null;
                    block24: for (ASN1Element e : subElements = ASN1Sequence.decodeAsSequence(elements[1]).elements()) {
                        switch (e.getType()) {
                            case -128: {
                                if (subInitialValue == null) {
                                    subInitialValue = ASN1OctetString.decodeAsOctetString(e);
                                    continue block24;
                                }
                                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_MV_FILTER_MULTIPLE_SUBINITIAL.get());
                            }
                            case -127: {
                                if (subAnyList == null) {
                                    subAnyList = new ArrayList<ASN1OctetString>(subElements.length);
                                }
                                subAnyList.add(ASN1OctetString.decodeAsOctetString(e));
                                continue block24;
                            }
                            case -126: {
                                if (subFinalValue == null) {
                                    subFinalValue = ASN1OctetString.decodeAsOctetString(e);
                                    continue block24;
                                }
                                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_MV_FILTER_MULTIPLE_SUBFINAL.get());
                            }
                            default: {
                                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_MV_FILTER_INVALID_SUB_TYPE.get(StaticUtils.toHex(e.getType())));
                            }
                        }
                    }
                    if (subAnyList != null) {
                        subAnyValues = subAnyList.toArray(new ASN1OctetString[subAnyList.size()]);
                    }
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    throw le;
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_MV_FILTER_CANNOT_DECODE_SUBSTRING.get(e), e);
                }
                if (subInitialValue != null || subAnyValues.length != 0 || subFinalValue != null) break;
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_MV_FILTER_NO_SUBSTRING_ELEMENTS.get());
            }
            case -121: {
                attributeType = ASN1OctetString.decodeAsOctetString(element).stringValue();
                break;
            }
            case -87: {
                try {
                    ASN1Element[] elements;
                    block25: for (ASN1Element e : elements = ASN1Sequence.decodeAsSequence(element).elements()) {
                        switch (e.getType()) {
                            case -126: {
                                if (attributeType == null) {
                                    attributeType = ASN1OctetString.decodeAsOctetString(e).stringValue();
                                    continue block25;
                                }
                                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_MV_FILTER_EXT_MULTIPLE_AT.get());
                            }
                            case -127: {
                                if (matchingRuleID == null) {
                                    matchingRuleID = ASN1OctetString.decodeAsOctetString(e).stringValue();
                                    continue block25;
                                }
                                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_MV_FILTER_MULTIPLE_MRID.get());
                            }
                            case -125: {
                                if (assertionValue == null) {
                                    assertionValue = ASN1OctetString.decodeAsOctetString(e);
                                    continue block25;
                                }
                                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_MV_FILTER_EXT_MULTIPLE_VALUE.get());
                            }
                            default: {
                                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_MV_FILTER_EXT_INVALID_TYPE.get(StaticUtils.toHex(e.getType())));
                            }
                        }
                    }
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    throw le;
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_MV_FILTER_EXT_NOT_SEQUENCE.get(e), e);
                }
                if (attributeType == null && matchingRuleID == null) {
                    throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_MV_FILTER_NO_ATTR_OR_MRID.get());
                }
                if (assertionValue != null) break;
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_MV_FILTER_EXT_NO_VALUE.get());
            }
            default: {
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_MV_FILTER_INVALID_TYPE.get(StaticUtils.toHex(matchType)));
            }
        }
        return new MatchedValuesFilter(matchType, attributeType, assertionValue, subInitialValue, subAnyValues, subFinalValue, matchingRuleID);
    }

    public Filter toFilter() {
        switch (this.matchType) {
            case -93: {
                return Filter.createEqualityFilter(this.attributeType, this.assertionValue.getValue());
            }
            case -92: {
                return Filter.createSubstringFilter(this.attributeType, this.getSubInitialValueBytes(), this.getSubAnyValueBytes(), this.getSubFinalValueBytes());
            }
            case -91: {
                return Filter.createGreaterOrEqualFilter(this.attributeType, this.assertionValue.getValue());
            }
            case -90: {
                return Filter.createLessOrEqualFilter(this.attributeType, this.assertionValue.getValue());
            }
            case -121: {
                return Filter.createPresenceFilter(this.attributeType);
            }
            case -88: {
                return Filter.createApproximateMatchFilter(this.attributeType, this.assertionValue.getValue());
            }
            case -87: {
                return Filter.createExtensibleMatchFilter(this.attributeType, this.matchingRuleID, false, this.assertionValue.getValue());
            }
        }
        return null;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append('(');
        switch (this.matchType) {
            case -93: {
                buffer.append(this.attributeType);
                buffer.append('=');
                buffer.append(this.assertionValue.stringValue());
                break;
            }
            case -92: {
                buffer.append(this.attributeType);
                buffer.append('=');
                if (this.subInitialValue != null) {
                    buffer.append(this.subInitialValue.stringValue());
                }
                for (ASN1OctetString s2 : this.subAnyValues) {
                    buffer.append('*');
                    buffer.append(s2.stringValue());
                }
                buffer.append('*');
                if (this.subFinalValue == null) break;
                buffer.append(this.subFinalValue.stringValue());
                break;
            }
            case -91: {
                buffer.append(this.attributeType);
                buffer.append(">=");
                buffer.append(this.assertionValue.stringValue());
                break;
            }
            case -90: {
                buffer.append(this.attributeType);
                buffer.append("<=");
                buffer.append(this.assertionValue.stringValue());
                break;
            }
            case -121: {
                buffer.append(this.attributeType);
                buffer.append("=*");
                break;
            }
            case -88: {
                buffer.append(this.attributeType);
                buffer.append("~=");
                buffer.append(this.assertionValue.stringValue());
                break;
            }
            case -87: {
                if (this.attributeType != null) {
                    buffer.append(this.attributeType);
                }
                if (this.matchingRuleID != null) {
                    buffer.append(':');
                    buffer.append(this.matchingRuleID);
                }
                buffer.append(":=");
                buffer.append(this.assertionValue.stringValue());
            }
        }
        buffer.append(')');
    }
}

