/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.matchingrules.BooleanMatchingRule;
import com.unboundid.ldap.matchingrules.DistinguishedNameMatchingRule;
import com.unboundid.ldap.matchingrules.IntegerMatchingRule;
import com.unboundid.ldap.matchingrules.MatchingRule;
import com.unboundid.ldap.matchingrules.OctetStringMatchingRule;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.ChangeType;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ModificationType;
import com.unboundid.ldap.sdk.RDN;
import com.unboundid.ldap.sdk.ReadOnlyEntry;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldif.LDIFAddChangeRecord;
import com.unboundid.ldif.LDIFChangeRecord;
import com.unboundid.ldif.LDIFDeleteChangeRecord;
import com.unboundid.ldif.LDIFException;
import com.unboundid.ldif.LDIFModifyChangeRecord;
import com.unboundid.ldif.LDIFModifyDNChangeRecord;
import com.unboundid.ldif.LDIFReader;
import com.unboundid.ldif.TrailingSpaceBehavior;
import com.unboundid.util.Debug;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

@NotExtensible
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public class ChangeLogEntry
extends ReadOnlyEntry {
    public static final String ATTR_CHANGE_NUMBER = "changeNumber";
    public static final String ATTR_TARGET_DN = "targetDN";
    public static final String ATTR_CHANGE_TYPE = "changeType";
    public static final String ATTR_CHANGES = "changes";
    public static final String ATTR_NEW_RDN = "newRDN";
    public static final String ATTR_DELETE_OLD_RDN = "deleteOldRDN";
    public static final String ATTR_NEW_SUPERIOR = "newSuperior";
    public static final String ATTR_DELETED_ENTRY_ATTRS = "deletedEntryAttrs";
    private static final long serialVersionUID = -4018129098468341663L;
    private final boolean deleteOldRDN;
    private final ChangeType changeType;
    private final List<Attribute> attributes;
    private final List<Modification> modifications;
    private final long changeNumber;
    private final String newRDN;
    private final String newSuperior;
    private final String targetDN;

    public ChangeLogEntry(Entry entry) throws LDAPException {
        super(entry);
        Attribute changeNumberAttr = entry.getAttribute(ATTR_CHANGE_NUMBER);
        if (changeNumberAttr == null || !changeNumberAttr.hasValue()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_CHANGELOG_NO_CHANGE_NUMBER.get());
        }
        try {
            this.changeNumber = Long.parseLong(changeNumberAttr.getValue());
        }
        catch (NumberFormatException nfe) {
            Debug.debugException(nfe);
            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_CHANGELOG_INVALID_CHANGE_NUMBER.get(changeNumberAttr.getValue()), nfe);
        }
        Attribute targetDNAttr = entry.getAttribute(ATTR_TARGET_DN);
        if (targetDNAttr == null || !targetDNAttr.hasValue()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_CHANGELOG_NO_TARGET_DN.get());
        }
        this.targetDN = targetDNAttr.getValue();
        Attribute changeTypeAttr = entry.getAttribute(ATTR_CHANGE_TYPE);
        if (changeTypeAttr == null || !changeTypeAttr.hasValue()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_CHANGELOG_NO_CHANGE_TYPE.get());
        }
        this.changeType = ChangeType.forName(changeTypeAttr.getValue());
        if (this.changeType == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_CHANGELOG_INVALID_CHANGE_TYPE.get(changeTypeAttr.getValue()));
        }
        switch (this.changeType) {
            case ADD: {
                this.attributes = ChangeLogEntry.parseAddAttributeList(entry, ATTR_CHANGES, this.targetDN);
                this.modifications = null;
                this.newRDN = null;
                this.deleteOldRDN = false;
                this.newSuperior = null;
                break;
            }
            case DELETE: {
                this.attributes = ChangeLogEntry.parseDeletedAttributeList(entry, this.targetDN);
                this.modifications = null;
                this.newRDN = null;
                this.deleteOldRDN = false;
                this.newSuperior = null;
                break;
            }
            case MODIFY: {
                this.attributes = null;
                this.modifications = ChangeLogEntry.parseModificationList(entry, this.targetDN);
                this.newRDN = null;
                this.deleteOldRDN = false;
                this.newSuperior = null;
                break;
            }
            case MODIFY_DN: {
                this.attributes = null;
                this.modifications = ChangeLogEntry.parseModificationList(entry, this.targetDN);
                this.newSuperior = this.getAttributeValue(ATTR_NEW_SUPERIOR);
                Attribute newRDNAttr = this.getAttribute(ATTR_NEW_RDN);
                if (newRDNAttr == null || !newRDNAttr.hasValue()) {
                    throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_CHANGELOG_MISSING_NEW_RDN.get());
                }
                this.newRDN = newRDNAttr.getValue();
                Attribute deleteOldRDNAttr = this.getAttribute(ATTR_DELETE_OLD_RDN);
                if (deleteOldRDNAttr == null || !deleteOldRDNAttr.hasValue()) {
                    throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_CHANGELOG_MISSING_DELETE_OLD_RDN.get());
                }
                String delOldRDNStr = StaticUtils.toLowerCase(deleteOldRDNAttr.getValue());
                if (delOldRDNStr.equals("true")) {
                    this.deleteOldRDN = true;
                    break;
                }
                if (delOldRDNStr.equals("false")) {
                    this.deleteOldRDN = false;
                    break;
                }
                throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_CHANGELOG_MISSING_DELETE_OLD_RDN.get(delOldRDNStr));
            }
            default: {
                throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_CHANGELOG_INVALID_CHANGE_TYPE.get(changeTypeAttr.getValue()));
            }
        }
    }

    public static ChangeLogEntry constructChangeLogEntry(long changeNumber, LDIFChangeRecord changeRecord) throws LDAPException {
        Entry e = new Entry("changeNumber=" + changeNumber + ",cn=changelog");
        e.addAttribute("objectClass", "top", "changeLogEntry");
        e.addAttribute(new Attribute(ATTR_CHANGE_NUMBER, (MatchingRule)IntegerMatchingRule.getInstance(), String.valueOf(changeNumber)));
        e.addAttribute(new Attribute(ATTR_TARGET_DN, (MatchingRule)DistinguishedNameMatchingRule.getInstance(), changeRecord.getDN()));
        e.addAttribute(ATTR_CHANGE_TYPE, changeRecord.getChangeType().getName());
        switch (changeRecord.getChangeType()) {
            case ADD: {
                LDIFAddChangeRecord addRecord = (LDIFAddChangeRecord)changeRecord;
                Entry addEntry = new Entry(addRecord.getDN(), addRecord.getAttributes());
                String[] entryLdifLines = addEntry.toLDIF(0);
                StringBuilder entryLDIFBuffer = new StringBuilder();
                for (int i = 1; i < entryLdifLines.length; ++i) {
                    entryLDIFBuffer.append(entryLdifLines[i]);
                    entryLDIFBuffer.append(StaticUtils.EOL);
                }
                e.addAttribute(new Attribute(ATTR_CHANGES, (MatchingRule)OctetStringMatchingRule.getInstance(), entryLDIFBuffer.toString()));
                break;
            }
            case DELETE: {
                break;
            }
            case MODIFY: {
                String[] modLdifLines = changeRecord.toLDIF(0);
                StringBuilder modLDIFBuffer = new StringBuilder();
                for (int i = 2; i < modLdifLines.length; ++i) {
                    modLDIFBuffer.append(modLdifLines[i]);
                    modLDIFBuffer.append(StaticUtils.EOL);
                }
                e.addAttribute(new Attribute(ATTR_CHANGES, (MatchingRule)OctetStringMatchingRule.getInstance(), modLDIFBuffer.toString()));
                break;
            }
            case MODIFY_DN: {
                LDIFModifyDNChangeRecord modDNRecord = (LDIFModifyDNChangeRecord)changeRecord;
                e.addAttribute(new Attribute(ATTR_NEW_RDN, (MatchingRule)DistinguishedNameMatchingRule.getInstance(), modDNRecord.getNewRDN()));
                e.addAttribute(new Attribute(ATTR_DELETE_OLD_RDN, (MatchingRule)BooleanMatchingRule.getInstance(), modDNRecord.deleteOldRDN() ? "TRUE" : "FALSE"));
                if (modDNRecord.getNewSuperiorDN() == null) break;
                e.addAttribute(new Attribute(ATTR_NEW_SUPERIOR, (MatchingRule)DistinguishedNameMatchingRule.getInstance(), modDNRecord.getNewSuperiorDN()));
            }
        }
        return new ChangeLogEntry(e);
    }

    protected static List<Attribute> parseAddAttributeList(Entry entry, String attrName, String targetDN) throws LDAPException {
        Attribute changesAttr = entry.getAttribute(attrName);
        if (changesAttr == null || !changesAttr.hasValue()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_CHANGELOG_MISSING_CHANGES.get());
        }
        ArrayList<String> ldifLines = new ArrayList<String>(20);
        ldifLines.add("dn: " + targetDN);
        StringTokenizer tokenizer = new StringTokenizer(changesAttr.getValue(), "\r\n");
        while (tokenizer.hasMoreTokens()) {
            ldifLines.add(tokenizer.nextToken());
        }
        String[] lineArray = new String[ldifLines.size()];
        ldifLines.toArray(lineArray);
        try {
            Entry e = LDIFReader.decodeEntry(true, TrailingSpaceBehavior.RETAIN, null, lineArray);
            return Collections.unmodifiableList(new ArrayList<Attribute>(e.getAttributes()));
        }
        catch (LDIFException le) {
            Debug.debugException(le);
            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_CHANGELOG_CANNOT_PARSE_ATTR_LIST.get(attrName, StaticUtils.getExceptionMessage(le)), le);
        }
    }

    private static List<Attribute> parseDeletedAttributeList(Entry entry, String targetDN) throws LDAPException {
        Attribute deletedEntryAttrs = entry.getAttribute(ATTR_DELETED_ENTRY_ATTRS);
        if (deletedEntryAttrs == null || !deletedEntryAttrs.hasValue()) {
            return null;
        }
        byte[] valueBytes = deletedEntryAttrs.getValueByteArray();
        if (valueBytes.length > 0 && valueBytes[valueBytes.length - 1] == 0) {
            String valueStr = new String(valueBytes, 0, valueBytes.length - 2, StandardCharsets.UTF_8);
            ArrayList<String> ldifLines = new ArrayList<String>(20);
            ldifLines.add("dn: " + targetDN);
            ldifLines.add("changetype: modify");
            StringTokenizer tokenizer = new StringTokenizer(valueStr, "\r\n");
            while (tokenizer.hasMoreTokens()) {
                ldifLines.add(tokenizer.nextToken());
            }
            String[] lineArray = new String[ldifLines.size()];
            ldifLines.toArray(lineArray);
            try {
                LDIFModifyChangeRecord changeRecord = (LDIFModifyChangeRecord)LDIFReader.decodeChangeRecord(lineArray);
                Modification[] mods = changeRecord.getModifications();
                ArrayList<Attribute> attrs = new ArrayList<Attribute>(mods.length);
                for (Modification m3 : mods) {
                    if (!m3.getModificationType().equals(ModificationType.DELETE)) {
                        throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_CHANGELOG_INVALID_DELENTRYATTRS_MOD_TYPE.get(ATTR_DELETED_ENTRY_ATTRS));
                    }
                    attrs.add(m3.getAttribute());
                }
                return Collections.unmodifiableList(attrs);
            }
            catch (LDIFException le) {
                Debug.debugException(le);
                throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_CHANGELOG_INVALID_DELENTRYATTRS_MODS.get(ATTR_DELETED_ENTRY_ATTRS, StaticUtils.getExceptionMessage(le)), le);
            }
        }
        ArrayList<String> ldifLines = new ArrayList<String>(20);
        ldifLines.add("dn: " + targetDN);
        StringTokenizer tokenizer = new StringTokenizer(deletedEntryAttrs.getValue(), "\r\n");
        while (tokenizer.hasMoreTokens()) {
            ldifLines.add(tokenizer.nextToken());
        }
        String[] lineArray = new String[ldifLines.size()];
        ldifLines.toArray(lineArray);
        try {
            Entry e = LDIFReader.decodeEntry(true, TrailingSpaceBehavior.RETAIN, null, lineArray);
            return Collections.unmodifiableList(new ArrayList<Attribute>(e.getAttributes()));
        }
        catch (LDIFException le) {
            Debug.debugException(le);
            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_CHANGELOG_CANNOT_PARSE_DELENTRYATTRS.get(ATTR_DELETED_ENTRY_ATTRS, StaticUtils.getExceptionMessage(le)), le);
        }
    }

    private static List<Modification> parseModificationList(Entry entry, String targetDN) throws LDAPException {
        StringTokenizer tokenizer;
        Attribute changesAttr = entry.getAttribute(ATTR_CHANGES);
        if (changesAttr == null || !changesAttr.hasValue()) {
            return null;
        }
        byte[] valueBytes = changesAttr.getValueByteArray();
        if (valueBytes.length == 0) {
            return null;
        }
        ArrayList<String> ldifLines = new ArrayList<String>(20);
        ldifLines.add("dn: " + targetDN);
        ldifLines.add("changetype: modify");
        if (valueBytes.length > 0 && valueBytes[valueBytes.length - 1] == 0) {
            String fullValue = changesAttr.getValue();
            String realValue = fullValue.substring(0, fullValue.length() - 2);
            tokenizer = new StringTokenizer(realValue, "\r\n");
        } else {
            tokenizer = new StringTokenizer(changesAttr.getValue(), "\r\n");
        }
        while (tokenizer.hasMoreTokens()) {
            ldifLines.add(tokenizer.nextToken());
        }
        String[] lineArray = new String[ldifLines.size()];
        ldifLines.toArray(lineArray);
        try {
            LDIFModifyChangeRecord changeRecord = (LDIFModifyChangeRecord)LDIFReader.decodeChangeRecord(lineArray);
            return Collections.unmodifiableList(Arrays.asList(changeRecord.getModifications()));
        }
        catch (LDIFException le) {
            Debug.debugException(le);
            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_CHANGELOG_CANNOT_PARSE_MOD_LIST.get(ATTR_CHANGES, StaticUtils.getExceptionMessage(le)), le);
        }
    }

    public final long getChangeNumber() {
        return this.changeNumber;
    }

    public final String getTargetDN() {
        return this.targetDN;
    }

    public final ChangeType getChangeType() {
        return this.changeType;
    }

    public final List<Attribute> getAddAttributes() {
        if (this.changeType == ChangeType.ADD) {
            return this.attributes;
        }
        return null;
    }

    public final List<Attribute> getDeletedEntryAttributes() {
        if (this.changeType == ChangeType.DELETE) {
            return this.attributes;
        }
        return null;
    }

    public final List<Modification> getModifications() {
        return this.modifications;
    }

    public final String getNewRDN() {
        return this.newRDN;
    }

    public final boolean deleteOldRDN() {
        return this.deleteOldRDN;
    }

    public final String getNewSuperior() {
        return this.newSuperior;
    }

    public final String getNewDN() {
        switch (this.changeType) {
            case ADD: 
            case MODIFY: {
                return this.targetDN;
            }
            case MODIFY_DN: {
                break;
            }
            default: {
                return null;
            }
        }
        try {
            RDN parsedNewRDN = new RDN(this.newRDN);
            if (this.newSuperior == null) {
                DN parsedTargetDN = new DN(this.targetDN);
                DN parentDN = parsedTargetDN.getParent();
                if (parentDN == null) {
                    return new DN(parsedNewRDN).toString();
                }
                return new DN(parsedNewRDN, parentDN).toString();
            }
            DN parsedNewSuperior = new DN(this.newSuperior);
            return new DN(parsedNewRDN, parsedNewSuperior).toString();
        }
        catch (Exception e) {
            Debug.debugException(e);
            return null;
        }
    }

    public final LDIFChangeRecord toLDIFChangeRecord() {
        switch (this.changeType) {
            case ADD: {
                return new LDIFAddChangeRecord(this.targetDN, this.attributes);
            }
            case DELETE: {
                return new LDIFDeleteChangeRecord(this.targetDN);
            }
            case MODIFY: {
                return new LDIFModifyChangeRecord(this.targetDN, this.modifications);
            }
            case MODIFY_DN: {
                return new LDIFModifyDNChangeRecord(this.targetDN, this.newRDN, this.deleteOldRDN, this.newSuperior);
            }
        }
        return null;
    }

    public final LDAPResult processChange(LDAPInterface connection) throws LDAPException {
        switch (this.changeType) {
            case ADD: {
                return connection.add(this.targetDN, this.attributes);
            }
            case DELETE: {
                return connection.delete(this.targetDN);
            }
            case MODIFY: {
                return connection.modify(this.targetDN, this.modifications);
            }
            case MODIFY_DN: {
                return connection.modifyDN(this.targetDN, this.newRDN, this.deleteOldRDN, this.newSuperior);
            }
        }
        return null;
    }
}

