/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.asn1;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Exception;
import com.unboundid.asn1.ASN1Messages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ASN1BitString
extends ASN1Element {
    private static final long serialVersionUID = -5962171503831966571L;
    private final boolean[] bits;
    private final byte[] bytes;

    public ASN1BitString(boolean ... bits) {
        this(3, bits);
    }

    public ASN1BitString(byte type, boolean ... bits) {
        this(type, bits, null, ASN1BitString.encodeValue(bits));
    }

    private ASN1BitString(byte type, boolean[] bits, byte[] bytes, byte[] encodedValue) {
        super(type, encodedValue);
        this.bits = bits;
        if (bytes == null) {
            if (bits.length % 8 == 0) {
                this.bytes = new byte[bits.length / 8];
                int currentByte = 0;
                int byteIndex = 0;
                for (int i = 0; i < bits.length; ++i) {
                    currentByte = (byte)(currentByte << 1);
                    if (bits[i]) {
                        currentByte = (byte)(currentByte | 1);
                    }
                    if ((i + 1) % 8 != 0) continue;
                    this.bytes[byteIndex++] = currentByte;
                    currentByte = 0;
                }
            } else {
                this.bytes = null;
            }
        } else {
            this.bytes = bytes;
        }
    }

    public ASN1BitString(String stringRepresentation) throws ASN1Exception {
        this(3, stringRepresentation);
    }

    public ASN1BitString(byte type, String stringRepresentation) throws ASN1Exception {
        this(type, ASN1BitString.getBits(stringRepresentation));
    }

    private static boolean[] getBits(String s2) throws ASN1Exception {
        char[] chars = s2.toCharArray();
        boolean[] bits = new boolean[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '0') {
                bits[i] = false;
                continue;
            }
            if (chars[i] == '1') {
                bits[i] = true;
                continue;
            }
            throw new ASN1Exception(ASN1Messages.ERR_BIT_STRING_DECODE_STRING_INVALID_CHAR.get());
        }
        return bits;
    }

    private static byte[] encodeValue(boolean ... bits) {
        byte[] encodedValue;
        int paddingBitsNeeded;
        int numBitsMod8 = bits.length % 8;
        if (numBitsMod8 == 0) {
            paddingBitsNeeded = 0;
            encodedValue = new byte[bits.length / 8 + 1];
        } else {
            paddingBitsNeeded = 8 - numBitsMod8;
            encodedValue = new byte[bits.length / 8 + 2];
        }
        encodedValue[0] = (byte)paddingBitsNeeded;
        int currentByte = 0;
        int bitIndex = 0;
        int encodedValueIndex = 1;
        for (boolean bit : bits) {
            currentByte = (byte)(currentByte << 1);
            if (bit) {
                currentByte = (byte)(currentByte | 1);
            }
            if (++bitIndex % 8 != 0) continue;
            encodedValue[encodedValueIndex] = currentByte;
            currentByte = 0;
            ++encodedValueIndex;
        }
        if (paddingBitsNeeded > 0) {
            encodedValue[encodedValueIndex] = currentByte = (int)((byte)(currentByte << paddingBitsNeeded));
        }
        return encodedValue;
    }

    public boolean[] getBits() {
        return this.bits;
    }

    public byte[] getBytes() throws ASN1Exception {
        if (this.bytes == null) {
            throw new ASN1Exception(ASN1Messages.ERR_BIT_STRING_GET_BYTES_NOT_MULTIPLE_OF_EIGHT_BITS.get(this.bits.length));
        }
        return this.bytes;
    }

    public static boolean[] getBitsForBytes(byte ... bytes) {
        boolean[] bits = new boolean[bytes.length * 8];
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            bits[i * 8] = (b & 0x80) == 128;
            bits[i * 8 + 1] = (b & 0x40) == 64;
            bits[i * 8 + 2] = (b & 0x20) == 32;
            bits[i * 8 + 3] = (b & 0x10) == 16;
            bits[i * 8 + 4] = (b & 8) == 8;
            bits[i * 8 + 5] = (b & 4) == 4;
            bits[i * 8 + 6] = (b & 2) == 2;
            bits[i * 8 + 7] = (b & 1) == 1;
        }
        return bits;
    }

    public static ASN1BitString decodeAsBitString(byte[] elementBytes) throws ASN1Exception {
        try {
            byte[] bytes;
            int valueStartPos = 2;
            int length = elementBytes[1] & 0x7F;
            if (length != elementBytes[1]) {
                int numLengthBytes = length;
                length = 0;
                for (int i = 0; i < numLengthBytes; ++i) {
                    length <<= 8;
                    length |= elementBytes[valueStartPos++] & 0xFF;
                }
            }
            if (elementBytes.length - valueStartPos != length) {
                throw new ASN1Exception(ASN1Messages.ERR_ELEMENT_LENGTH_MISMATCH.get(length, elementBytes.length - valueStartPos));
            }
            byte[] elementValue = new byte[length];
            System.arraycopy(elementBytes, valueStartPos, elementValue, 0, length);
            boolean[] bits = ASN1BitString.decodeValue(elementValue);
            if (bits.length % 8 == 0) {
                bytes = new byte[elementValue.length - 1];
                System.arraycopy(elementValue, 1, bytes, 0, bytes.length);
            } else {
                bytes = null;
            }
            return new ASN1BitString(elementBytes[0], bits, bytes, elementValue);
        }
        catch (ASN1Exception ae) {
            Debug.debugException(ae);
            throw ae;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new ASN1Exception(ASN1Messages.ERR_ELEMENT_DECODE_EXCEPTION.get(e), e);
        }
    }

    public static ASN1BitString decodeAsBitString(ASN1Element element) throws ASN1Exception {
        byte[] bytes;
        byte[] elementValue = element.getValue();
        boolean[] bits = ASN1BitString.decodeValue(elementValue);
        if (bits.length % 8 == 0) {
            bytes = new byte[elementValue.length - 1];
            System.arraycopy(elementValue, 1, bytes, 0, bytes.length);
        } else {
            bytes = null;
        }
        return new ASN1BitString(element.getType(), bits, bytes, element.getValue());
    }

    private static boolean[] decodeValue(byte[] elementValue) throws ASN1Exception {
        if (elementValue.length == 0) {
            throw new ASN1Exception(ASN1Messages.ERR_BIT_STRING_DECODE_EMPTY_VALUE.get());
        }
        int paddingBitsNeeded = elementValue[0] & 0xFF;
        if (paddingBitsNeeded > 7) {
            throw new ASN1Exception(ASN1Messages.ERR_BIT_STRING_DECODE_INVALID_PADDING_BIT_COUNT.get(paddingBitsNeeded));
        }
        if (paddingBitsNeeded > 0 && elementValue.length == 1) {
            throw new ASN1Exception(ASN1Messages.ERR_BIT_STRING_DECODE_NONZERO_PADDING_BIT_COUNT_WITH_NO_MORE_BYTES.get());
        }
        int bitsIndex = 0;
        int numBits = (elementValue.length - 1) * 8 - paddingBitsNeeded;
        boolean[] bits = new boolean[numBits];
        for (int i = 1; i < elementValue.length; ++i) {
            byte b = elementValue[i];
            if (i == elementValue.length - 1 && paddingBitsNeeded > 0) {
                for (int j = 0; j < 8 - paddingBitsNeeded; ++j) {
                    bits[bitsIndex++] = (b & 0x80) == 128;
                    b = (byte)(b << 1);
                }
                continue;
            }
            bits[bitsIndex++] = (b & 0x80) == 128;
            bits[bitsIndex++] = (b & 0x40) == 64;
            bits[bitsIndex++] = (b & 0x20) == 32;
            bits[bitsIndex++] = (b & 0x10) == 16;
            bits[bitsIndex++] = (b & 8) == 8;
            bits[bitsIndex++] = (b & 4) == 4;
            bits[bitsIndex++] = (b & 2) == 2;
            bits[bitsIndex++] = (b & 1) == 1;
        }
        return bits;
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.ensureCapacity(buffer.length() + this.bits.length);
        for (boolean bit : this.bits) {
            if (bit) {
                buffer.append('1');
                continue;
            }
            buffer.append('0');
        }
    }
}

