/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.servlets.api.install;

import com.google.gson.Gson;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Reader;
import net.jami.jams.authmodule.PasswordUtil;
import net.jami.jams.common.annotations.JsonContent;
import net.jami.jams.common.authentication.AuthenticationSourceType;
import net.jami.jams.common.authmodule.AuthTokenResponse;
import net.jami.jams.common.objects.requests.CredentialsRequest;
import net.jami.jams.common.objects.user.AccessLevel;
import net.jami.jams.common.objects.user.User;
import net.jami.jams.common.serialization.adapters.GsonFactory;
import net.jami.jams.server.Server;
import net.jami.jams.server.servlets.api.auth.login.AuthRequestProcessor;
import net.jami.jams.server.servlets.api.install.CachedObjects;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(value={"/api/install/start"})
public class StartInstallServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(StartInstallServlet.class);
    private final Gson gson = GsonFactory.createGson();

    @Override
    @JsonContent
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean showLogin = Server.dataStore != null && Server.dataStore.getUserDao() != null && !Server.dataStore.getUserDao().getAll().isEmpty();
        resp.setHeader("showLogin", showLogin ? "true" : "false");
    }

    @Override
    @JsonContent
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        CredentialsRequest credentialsRequest = this.gson.fromJson((Reader)req.getReader(), CredentialsRequest.class);
        AuthTokenResponse res = null;
        if (credentialsRequest.getUsername() != null && credentialsRequest.getPassword() != null) {
            res = AuthRequestProcessor.processUsernamePasswordAuth(credentialsRequest.getUsername(), credentialsRequest.getPassword());
        }
        resp.setHeader("endpoint", CachedObjects.endpoint);
        if (res == null) {
            resp.sendError(403, "Unable to authenticate!");
        } else {
            resp.getOutputStream().write(this.gson.toJson(res).getBytes());
            resp.flushBuffer();
        }
    }

    @Override
    @JsonContent
    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!Server.dataStore.getUserDao().getAll().isEmpty()) {
            resp.sendError(500, "We have tried to create an administrative account where one already exists!");
            return;
        }
        CredentialsRequest credentialsRequest = this.gson.fromJson((Reader)req.getReader(), CredentialsRequest.class);
        byte[] salt = PasswordUtil.generateSalt();
        String pw = PasswordUtil.hashPassword(credentialsRequest.getPassword(), salt);
        User user = new User();
        user.setUsername(credentialsRequest.getUsername());
        user.setPassword(pw);
        user.setSalt(Base64.encodeBase64String(salt));
        user.setUserType(AuthenticationSourceType.LOCAL);
        user.setRealm("LOCAL");
        user.setAccessLevel(AccessLevel.ADMIN);
        Server.dataStore.getUserDao().storeObject(user);
        AuthTokenResponse res = AuthRequestProcessor.processUsernamePasswordAuth(user.getUsername(), credentialsRequest.getPassword());
        CachedObjects.endpoint = "/api/install/ca";
        resp.getOutputStream().write(this.gson.toJson(res).getBytes());
        resp.flushBuffer();
    }
}

