/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.servlets.api.admin.update;

import com.google.gson.Gson;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import net.jami.jams.common.annotations.JsonContent;
import net.jami.jams.common.objects.user.AccessLevel;
import net.jami.jams.common.serialization.adapters.GsonFactory;
import net.jami.jams.common.serialization.tomcat.TomcatCustomErrorHandler;
import net.jami.jams.common.updater.FullSystemStatusResponse;
import net.jami.jams.server.Server;

@WebServlet(value={"/api/admin/update"})
public class UpdateServlet
extends HttpServlet {
    private final Gson gson = GsonFactory.createGson();

    @Override
    @JsonContent
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)req.getAttribute("accessLevel");
        if (accessLevel == AccessLevel.valueOf((String)"ADMIN")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError((HttpServletResponse)resp, (int)403, (String)"You do not have sufficient permissions to access this resource!");
            return;
        }
        FullSystemStatusResponse response = new FullSystemStatusResponse();
        response.setLocalVersions(Server.appUpdater.getLocalVersions());
        response.setRemoteVersions(Server.appUpdater.getRemoteVersions());
        response.setUpdateAvailable(Boolean.valueOf(Server.appUpdater.getUpdateAvailable()));
        resp.getOutputStream().write(this.gson.toJson(response).getBytes());
        resp.flushBuffer();
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)req.getAttribute("accessLevel");
        if (accessLevel == AccessLevel.valueOf((String)"ADMIN")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError((HttpServletResponse)resp, (int)403, (String)"You do not have sufficient permissions to access this resource!");
            return;
        }
        if (Server.appUpdater.getUpdateAvailable()) {
            Server.appUpdater.doUpdate();
        }
    }
}

