/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.servlets.api.admin.group;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Optional;
import net.jami.jams.common.annotations.JsonContent;
import net.jami.jams.common.objects.user.AccessLevel;
import net.jami.jams.common.objects.user.UserGroupMapping;
import net.jami.jams.common.serialization.adapters.GsonFactory;
import net.jami.jams.common.serialization.tomcat.TomcatCustomErrorHandler;
import net.jami.jams.server.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(value={"/api/admin/group/members/*"})
public class UserGroupServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(UserGroupServlet.class);
    private final Gson gson = GsonFactory.createGson();

    @Override
    @JsonContent
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)req.getAttribute("accessLevel");
        if (accessLevel == AccessLevel.valueOf((String)"ADMIN")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError((HttpServletResponse)resp, (int)403, (String)"You do not have sufficient permissions to access this resource!");
            return;
        }
        String groupId = req.getPathInfo().replace("/", "");
        List<UserGroupMapping> result = Server.dataStore.getUserGroupMappingsDao().getByGroupId(groupId);
        resp.getOutputStream().write(this.gson.toJson(result).getBytes());
        resp.flushBuffer();
        resp.setStatus(200);
    }

    @Override
    @JsonContent
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)req.getAttribute("accessLevel");
        if (accessLevel == AccessLevel.valueOf((String)"ADMIN")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError((HttpServletResponse)resp, (int)403, (String)"You do not have sufficient permissions to access this resource!");
            return;
        }
        String groupId = req.getPathInfo().replace("/", "");
        JsonObject obj = this.gson.fromJson((Reader)req.getReader(), JsonObject.class);
        String username = obj.get("username").getAsString();
        Optional<UserGroupMapping> existingMapping = Server.dataStore.getUserGroupMappingsDao().getByGroupIdAndUsername(groupId, username);
        if (existingMapping.isPresent()) {
            resp.sendError(409, "The user already part of the group!");
            return;
        }
        UserGroupMapping mapping = new UserGroupMapping();
        mapping.setGroupId(groupId);
        mapping.setUsername(username);
        if (Server.dataStore.getUserGroupMappingsDao().storeObject(mapping)) {
            resp.setStatus(200);
        } else {
            resp.sendError(500, "Unable to add user to group!");
        }
    }

    @Override
    @JsonContent
    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)req.getAttribute("accessLevel");
        if (accessLevel == AccessLevel.valueOf((String)"ADMIN")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError((HttpServletResponse)resp, (int)403, (String)"You do not have sufficient permissions to access this resource!");
            return;
        }
        String groupId = req.getPathInfo().replace("/", "");
        JsonObject obj = this.gson.fromJson((Reader)req.getReader(), JsonObject.class);
        String username = obj.get("username").getAsString();
        if (Server.dataStore.getUserGroupMappingsDao().deleteObject(username, groupId)) {
            resp.setStatus(200);
        } else {
            resp.sendError(500, "Unable to delete mapping between user and group!");
        }
    }
}

