/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.servlets;

import com.google.gson.Gson;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Reader;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Optional;
import net.jami.jams.ca.JamsCA;
import net.jami.jams.common.annotations.JsonContent;
import net.jami.jams.common.authmodule.AuthTokenResponse;
import net.jami.jams.common.objects.user.User;
import net.jami.jams.common.serialization.adapters.GsonFactory;
import net.jami.jams.common.serialization.tomcat.TomcatCustomErrorHandler;
import net.jami.jams.server.Server;
import net.jami.jams.server.servlets.api.auth.login.AuthRequestProcessor;
import net.jami.jams.server.servlets.api.auth.login.LoginRequest;
import org.bouncycastle.cert.X509CRLHolder;

@WebServlet(value={"/api/login"})
public class LoginServlet
extends HttpServlet {
    private final Gson gson = GsonFactory.createGson();

    @Override
    @JsonContent
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        AuthTokenResponse res = null;
        if (req.getHeader("authorization") != null) {
            res = AuthRequestProcessor.processUsernamePasswordAuth(req.getHeader("authorization"));
        }
        String clientCert = req.getHeader("X-Client-Cert");
        if (JamsCA.reverseProxy && clientCert != null) {
            try {
                String decodedHeader = URLDecoder.decode(clientCert, StandardCharsets.UTF_8.name());
                String pem = decodedHeader.replace("-----BEGIN CERTIFICATE-----", "").replace("-----END CERTIFICATE-----", "").replaceAll("\\s+", "");
                byte[] decodedBytes = Base64.getDecoder().decode(pem);
                CertificateFactory factory = CertificateFactory.getInstance("X.509");
                ByteArrayInputStream in = new ByteArrayInputStream(decodedBytes);
                X509Certificate certificate = (X509Certificate)factory.generateCertificate(in);
                res = AuthRequestProcessor.processX509Auth(certificate);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (req.getAttribute("jakarta.servlet.request.X509Certificate") != null) {
            res = AuthRequestProcessor.processX509Auth((X509Certificate[])req.getAttribute("jakarta.servlet.request.X509Certificate"));
        } else {
            LoginRequest object = this.gson.fromJson((Reader)req.getReader(), LoginRequest.class);
            if (object.getUsername() != null && object.getPassword() != null) {
                res = AuthRequestProcessor.processUsernamePasswordAuth(object.getUsername(), object.getPassword());
                Optional<User> user = Server.dataStore.getUserDao().getByUsername(object.getUsername());
                if (user.isPresent() && Server.certificateAuthority.getLatestCRL().get() != null && !user.get().getAccessLevelName().equals("ADMIN") && ((X509CRLHolder)Server.certificateAuthority.getLatestCRL().get()).getRevokedCertificate(user.get().getCertificate().getSerialNumber()) != null) {
                    TomcatCustomErrorHandler.sendCustomError((HttpServletResponse)resp, (int)401, (String)"Invalid credentials provided!");
                }
            }
        }
        resp.setContentType("application/json;charset=UTF-8");
        if (res == null) {
            TomcatCustomErrorHandler.sendCustomError((HttpServletResponse)resp, (int)401, (String)"Invalid credentials provided!");
        } else {
            resp.getOutputStream().write(this.gson.toJson(res).getBytes());
            resp.flushBuffer();
        }
    }
}

