/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.nameserver;

import java.util.List;
import java.util.Optional;
import net.jami.datastore.main.DataStore;
import net.jami.jams.common.authentication.AuthenticationSource;
import net.jami.jams.common.authmodule.AuthModuleKey;
import net.jami.jams.common.authmodule.AuthenticationModule;
import net.jami.jams.common.jami.NameLookupResponse;
import net.jami.jams.common.jami.NameRegistrationRequest;
import net.jami.jams.common.jami.NameServer;
import net.jami.jams.common.objects.user.AccessLevel;
import net.jami.jams.common.objects.user.User;
import net.jami.jams.common.objects.user.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalNameServer
implements NameServer {
    private static final Logger log = LoggerFactory.getLogger(LocalNameServer.class);
    private static final String NAME_SERVER_PATH = "/api/nameserver";
    private final DataStore dataStore;
    private final String nameserverURI;
    private final AuthenticationModule authenticationModule;

    public LocalNameServer(DataStore dataStore, AuthenticationModule authenticationModule, String nameserverURI) {
        this.dataStore = dataStore;
        this.nameserverURI = nameserverURI;
        this.authenticationModule = authenticationModule;
    }

    public Integer registerName(String username, NameRegistrationRequest nameRegistrationRequest) {
        return 200;
    }

    public NameLookupResponse getAddressFromName(String username) {
        Optional<User> result = this.dataStore.getUserDao().getByUsername(username);
        if (result.isEmpty()) {
            User user = new User();
            for (AuthModuleKey key : this.authenticationModule.getAuthSources().keySet()) {
                UserProfile profile = ((AuthenticationSource)this.authenticationModule.getAuthSources().get(key)).getUserProfile(username);
                if (profile == null) continue;
                user.setUsername(profile.getUsername());
                user.setRealm(key.getRealm());
                user.setUserType(key.getType());
                user.setAccessLevel(AccessLevel.USER);
                this.authenticationModule.createUser(user.getUserType(), user.getRealm(), (NameServer)this, user);
                break;
            }
            if (user.getUsername() == null) {
                return null;
            }
            result = this.dataStore.getUserDao().getByUsername(username);
            if (result.isEmpty()) {
                return null;
            }
        }
        NameLookupResponse nameLookupResponse = new NameLookupResponse();
        nameLookupResponse.setName(result.get().getUsername());
        nameLookupResponse.setAddr(result.get().getJamiId());
        return nameLookupResponse;
    }

    public String getNameFromAddress(String address) {
        List<User> results = this.dataStore.getUserDao().getByJamiId(address);
        if (results.isEmpty()) {
            return null;
        }
        return results.get(0).getUsername();
    }

    public String getURI() {
        return this.nameserverURI + NAME_SERVER_PATH;
    }
}

