/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.ca.workers.ocsp;

import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import net.jami.jams.ca.JamsCA;
import net.jami.jams.ca.workers.X509Worker;
import net.jami.jams.ca.workers.crl.CRLWorker;
import net.jami.jams.common.cryptoengineapi.ocsp.CertificateStatus;
import net.jami.jams.common.cryptoengineapi.ocsp.CertificateSummary;
import net.jami.jams.common.cryptoengineapi.ocsp.OCSPCertificateStatusMapper;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CRLEntryHolder;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.BasicOCSPRespBuilder;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPReq;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.OCSPRespBuilder;
import org.bouncycastle.cert.ocsp.Req;
import org.bouncycastle.cert.ocsp.RespID;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OCSPWorker
extends X509Worker<String> {
    private static final Logger log = LoggerFactory.getLogger(OCSPWorker.class);
    private final CRLWorker crlWorker;
    private final RespID responderID;
    private final ContentSigner contentSigner;
    private final JcaContentVerifierProviderBuilder contentVerifierProvider = new JcaContentVerifierProviderBuilder().setProvider("BC");

    public OCSPWorker(PrivateKey privateKey, X509Certificate certificate, CRLWorker crlWorker) throws Exception {
        super(privateKey, certificate);
        this.crlWorker = crlWorker;
        DigestCalculatorProvider digestCalculatorProvider = new JcaDigestCalculatorProviderBuilder().setProvider("BC").build();
        this.responderID = new RespID(SubjectPublicKeyInfo.getInstance((Object)JamsCA.CA.getCertificate().getPublicKey().getEncoded()), digestCalculatorProvider.get(new DefaultDigestAlgorithmIdentifierFinder().find("SHA-1")));
        this.contentSigner = new JcaContentSignerBuilder("SHA256withRSA").setProvider("BC").build(JamsCA.CA.getPrivateKey());
        log.info("Instantiated OCSP Worker...");
    }

    public OCSPResp getOCSPResponse(OCSPReq ocspRequest, X509Certificate certificate, PrivateKey privateKey, Boolean unknown) throws OCSPException {
        try {
            if (this.validateRequest(ocspRequest) != null) {
                throw new OCSPException("Request is not valid");
            }
            BasicOCSPRespBuilder responseBuilder = new BasicOCSPRespBuilder(this.responderID);
            ArrayList<Extension> responseExtensions = new ArrayList<Extension>();
            Extension nonceExtension = ocspRequest.getExtension(OCSPObjectIdentifiers.id_pkix_ocsp_nonce);
            if (nonceExtension != null) {
                responseExtensions.add(nonceExtension);
            }
            Extension[] extensions = responseExtensions.toArray(new Extension[responseExtensions.size()]);
            responseBuilder.setResponseExtensions(new Extensions(extensions));
            for (Req request : ocspRequest.getRequestList()) {
                this.addResponse(responseBuilder, request, unknown);
            }
            BasicOCSPResp basicResponse = responseBuilder.build(new JcaContentSignerBuilder("SHA256withRSA").setProvider("BC").build(privateKey), new X509CertificateHolder[]{new JcaX509CertificateHolder(certificate)}, new Date());
            return new OCSPRespBuilder().build(0, (Object)basicResponse);
        }
        catch (Exception e) {
            log.error("An OCSP request error occurred while verifying signature: {}", (Object)e.getMessage());
            return null;
        }
    }

    private OCSPResp validateRequest(OCSPReq ocspRequest) throws Exception {
        if (ocspRequest == null || ocspRequest.isSigned() && !ocspRequest.isSignatureValid(this.contentVerifierProvider.build(ocspRequest.getCerts()[0]))) {
            return new OCSPRespBuilder().build(1, null);
        }
        return null;
    }

    private CertificateSummary getCertificateSummary(BigInteger serial, Boolean unknown) {
        if (unknown.booleanValue()) {
            return CertificateSummary.newBuilder().withStatus(CertificateStatus.UNKNOWN).withSerialNumber(serial).build();
        }
        X509CRLEntryHolder x509CRLEntryHolder = this.crlWorker.getExistingCRL().get().getRevokedCertificate(serial);
        if (x509CRLEntryHolder != null) {
            return CertificateSummary.newBuilder().withStatus(CertificateStatus.REVOKED).withSerialNumber(serial).withRevocationTime(LocalDateTime.ofInstant(x509CRLEntryHolder.getRevocationDate().toInstant(), ZoneId.systemDefault())).build();
        }
        return CertificateSummary.newBuilder().withStatus(CertificateStatus.VALID).withSerialNumber(serial).build();
    }

    private void addResponse(BasicOCSPRespBuilder responseBuilder, Req request, Boolean unknown) throws OCSPException {
        CertificateID certificateID = request.getCertID();
        Extensions requestExtensions = request.getSingleRequestExtensions();
        if (requestExtensions != null) {
            Extension nonceExtension = requestExtensions.getExtension(OCSPObjectIdentifiers.id_pkix_ocsp_nonce);
            Extensions extensions = new Extensions(nonceExtension);
            responseBuilder.addResponse(certificateID, OCSPCertificateStatusMapper.getStatus((CertificateSummary)this.getCertificateSummary(request.getCertID().getSerialNumber(), unknown)), new Date(), new Date(new Date().getTime() + JamsCA.crlLifetime), extensions);
        } else {
            responseBuilder.addResponse(certificateID, OCSPCertificateStatusMapper.getStatus((CertificateSummary)this.getCertificateSummary(request.getCertID().getSerialNumber(), unknown)), new Date(), new Date(new Date().getTime() + JamsCA.crlLifetime));
        }
    }
}

