/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.ad.connector;

import com.google.gson.Gson;
import com.imperva.ddc.core.query.Endpoint;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.jami.datastore.main.DataStore;
import net.jami.jams.ad.connector.service.AuthenticationService;
import net.jami.jams.ad.connector.service.UserProfileService;
import net.jami.jams.common.authentication.AuthenticationSource;
import net.jami.jams.common.authentication.AuthenticationSourceInfo;
import net.jami.jams.common.authentication.AuthenticationSourceType;
import net.jami.jams.common.authentication.activedirectory.ActiveDirectorySettings;
import net.jami.jams.common.objects.user.User;
import net.jami.jams.common.objects.user.UserProfile;
import net.jami.jams.common.serialization.adapters.GsonFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ADConnector
implements AuthenticationSource {
    private static final Logger log = LoggerFactory.getLogger(ADConnector.class);
    private static final ConcurrentLinkedQueue<Endpoint> endpoints = new ConcurrentLinkedQueue();
    public static ActiveDirectorySettings settings;
    private final AuthenticationService authenticationService = new AuthenticationService();
    private final UserProfileService userProfileService;
    private DataStore dataStore;

    public ADConnector(String settings, DataStore dataStore) {
        Gson gson = GsonFactory.createGson();
        ADConnector.settings = gson.fromJson(settings, ActiveDirectorySettings.class);
        for (int i = 0; i < 10; ++i) {
            Endpoint endpoint = new Endpoint();
            endpoint.setSecuredConnection(ADConnector.settings.getIsSSL());
            endpoint.setPort(ADConnector.settings.getPort());
            endpoint.setHost(ADConnector.settings.getHost());
            endpoints.add(endpoint);
        }
        this.dataStore = dataStore;
        this.userProfileService = new UserProfileService(dataStore);
        ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
        Runnable synchronizationTask = this.userProfileService::synchronizeUsersWithAD;
        long initialDelay = 1L;
        long period = 1L;
        scheduler.scheduleAtFixedRate(synchronizationTask, initialDelay, period, TimeUnit.MINUTES);
        log.info("Started Active Directory Connector!");
    }

    public static Endpoint getConnection() {
        Endpoint endpoint = null;
        while (endpoint == null) {
            endpoint = endpoints.poll();
        }
        endpoint.setUserAccountName(settings.getRealm() + "\\" + settings.getUsername());
        endpoint.setPassword(settings.getPassword());
        return endpoint;
    }

    public static Endpoint getConnection(String username, String password) {
        Endpoint endpoint = null;
        while (endpoint == null) {
            endpoint = endpoints.poll();
        }
        endpoint.setUserAccountName(settings.getRealm() + "\\" + username);
        endpoint.setPassword(password);
        return endpoint;
    }

    public static void returnConnection(Endpoint connection) {
        connection.setUserAccountName(settings.getRealm() + "\\" + settings.getUsername());
        connection.setPassword(settings.getPassword());
        endpoints.add(connection);
    }

    public boolean createUser(User user) {
        return false;
    }

    public List<UserProfile> searchUserProfiles(String queryString, String field, Optional<Integer> page) {
        List<UserProfile> results = this.userProfileService.getUserProfile(queryString, field, false, page);
        if (results == null) {
            results = this.dataStore.searchUserProfiles(queryString, field, page);
        }
        return results;
    }

    public UserProfile getUserProfile(String username) {
        List<UserProfile> results = this.userProfileService.getUserProfile(username, "LOGON_NAME", true, Optional.empty());
        if (results == null) {
            return this.dataStore.getUserProfile(username);
        }
        if (results.size() != 1) {
            return null;
        }
        return results.get(0);
    }

    public boolean setUserProfile(UserProfile userProfile) {
        return false;
    }

    public boolean authenticate(String username, String password) {
        try {
            return this.authenticationService.authenticateUser(username, password);
        }
        catch (Exception e) {
            return false;
        }
    }

    public AuthenticationSourceInfo getInfo() {
        return new AuthenticationSourceInfo(settings.getRealm(), AuthenticationSourceType.AD);
    }

    public boolean test() {
        return this.authenticate(settings.getUsername(), settings.getPassword());
    }

    public boolean updatePassword(User user, String password) {
        return false;
    }
}

